/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.framework;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.jsfunit.context.JSFUnitFacesContext;
import org.jboss.jsfunit.framework.WebConversationFactory;

public class JSFUnitFilter
implements Filter {
    private ServletContext servletContext;

    private void putWarURLinApplication(HttpServletRequest request) {
        if (this.servletContext.getAttribute(WebConversationFactory.WAR_URL) != null) {
            return;
        }
        this.servletContext.setAttribute(WebConversationFactory.WAR_URL, (Object)WebConversationFactory.makeWARURL(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        JSFUnitFacesContext.cleanUpOldFacesContext();
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        this.putWarURLinApplication(request);
        try {
            WebConversationFactory.setThreadLocals(request);
            System.setProperty("cactus.contextURL", WebConversationFactory.getWARURL());
            if (this.isSnoopRequest(request)) {
                this.snoop(request, response);
                return;
            }
            filterChain.doFilter(req, res);
        }
        finally {
            HttpSession session = ((HttpServletRequest)req).getSession(false);
            if (session != null) {
                session.removeAttribute(JSFUnitFacesContext.SESSION_KEY);
            }
            WebConversationFactory.removeThreadLocals();
        }
    }

    private boolean isSnoopRequest(HttpServletRequest request) {
        return request.getParameter("jsfunit.snoop") != null;
    }

    private void snoop(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println("<p>HttpSession Values</p>");
        HttpSession session = request.getSession();
        Enumeration attribs = session.getAttributeNames();
        while (attribs.hasMoreElements()) {
            String attribute = (String)attribs.nextElement();
            writer.print(attribute + " = " + session.getAttribute(attribute).toString());
            writer.println("<br/>");
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
    }

    public void destroy() {
        this.servletContext = null;
    }
}

