/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.framework;

import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.WebClient;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.jsfunit.context.JSFUnitFacesContext;
import org.jboss.jsfunit.framework.JSFUnitWebConnection;
import org.jboss.jsfunit.framework.WebClientSpec;
import org.jboss.jsfunit.seam.SeamUtil;
import org.jboss.seam.contexts.ServletLifecycle;

public class WebConversationFactory {
    public static String JSF_UNIT_CONVERSATION_FLAG = WebConversationFactory.class.getName() + ".testing_flag";
    public static String WAR_URL = WebConversationFactory.class.getName() + ".WARURL";
    private static ThreadLocal tlsession = new ThreadLocal(){

        protected Object initialValue() {
            return null;
        }
    };
    private static ThreadLocal warURL = new ThreadLocal(){

        protected Object initialValue() {
            return null;
        }
    };

    public static void setThreadLocals(HttpServletRequest req) {
        tlsession.set(req.getSession());
        String stringWARURL = WebConversationFactory.makeWARURL(req);
        warURL.set(stringWARURL);
    }

    protected static HttpSession getSessionFromThreadLocal() {
        return (HttpSession)tlsession.get();
    }

    public static String makeWARURL(HttpServletRequest req) {
        return req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath();
    }

    public static void removeThreadLocals() {
        tlsession.remove();
        warURL.remove();
    }

    private WebConversationFactory() {
    }

    static void makeWebClient(WebClientSpec wcSpec) {
        WebClient wc = null;
        String proxyHost = wcSpec.getProxyHost();
        if (proxyHost != null) {
            wc = new WebClient(wcSpec.getBrowserVersion(), proxyHost, wcSpec.getProxyPort());
        }
        if (proxyHost == null) {
            wc = new WebClient(wcSpec.getBrowserVersion());
        }
        wc.setAjaxController(new NicelyResynchronizingAjaxController());
        wc.setWebConnection(new JSFUnitWebConnection(wc.getWebConnection()));
        wcSpec.setWebClient(wc);
        HttpSession session = WebConversationFactory.getSessionFromThreadLocal();
        if (session == null) {
            throw new IllegalStateException("Can not find HttpSession.  Perhaps JSFUnitFilter has not run?");
        }
        WebConversationFactory.clearSession(session);
        session.setAttribute(WebClientSpec.SESSION_KEY, (Object)wcSpec);
        wcSpec.addCookie("JSESSIONID", session.getId());
        wcSpec.addCookie(JSF_UNIT_CONVERSATION_FLAG, JSF_UNIT_CONVERSATION_FLAG);
    }

    protected static void clearSession(HttpSession session) {
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            session.removeAttribute((String)e.nextElement());
        }
        JSFUnitFacesContext.cleanUpOldFacesContext();
        if (SeamUtil.isSeamInitialized()) {
            ServletLifecycle.beginSession((HttpSession)session);
        }
    }

    public static String getWARURL() {
        return (String)warURL.get();
    }
}

