/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.JavaScriptPage;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PageCreator;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.XHtmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class DefaultPageCreator
implements PageCreator,
Serializable {
    private static final long serialVersionUID = -4420355214574495577L;

    public Page createPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        XmlPage xml;
        DomElement doc;
        String contentType = this.determineContentType(webResponse.getContentType().toLowerCase(), webResponse.getContentAsStream());
        String pageType = this.determinePageType(contentType);
        Page newPage = pageType.equals("html") ? this.createHtmlPage(webResponse, webWindow) : (pageType.equals("javascript") ? this.createJavaScriptPage(webResponse, webWindow) : (pageType.equals("xml") ? ((doc = (xml = this.createXmlPage(webResponse, webWindow)).getDocumentElement()) != null && "http://www.w3.org/1999/xhtml".equals(doc.getNamespaceURI()) ? this.createXHtmlPage(webResponse, webWindow) : xml) : (pageType.equals("text") ? this.createTextPage(webResponse, webWindow) : this.createUnexpectedPage(webResponse, webWindow))));
        return newPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String determineContentType(String contentType, InputStream contentAsStream) throws IOException {
        byte[] markerUTF8 = new byte[]{-17, -69, -65};
        byte[] markerUTF16BE = new byte[]{-2, -1};
        byte[] markerUTF16LE = new byte[]{-1, -2};
        try {
            if (!StringUtils.isEmpty(contentType)) {
                String string = contentType;
                return string;
            }
            byte[] bytes = this.read(contentAsStream, 500);
            if (bytes.length == 0) {
                String string = "text/plain";
                return string;
            }
            String asAsciiString = new String(bytes, "ASCII").toUpperCase(Locale.ENGLISH);
            if (asAsciiString.contains("<HTML")) {
                String string = "text/html";
                return string;
            }
            if (this.startsWith(bytes, markerUTF8) || this.startsWith(bytes, markerUTF16BE) || this.startsWith(bytes, markerUTF16LE)) {
                String string = "text/plain";
                return string;
            }
            if (this.isBinary(bytes)) {
                String string = "application/octet-stream";
                return string;
            }
        }
        finally {
            IOUtils.closeQuietly(contentAsStream);
        }
        return "text/plain";
    }

    private boolean isBinary(byte[] bytes) {
        for (byte b : bytes) {
            if (b >= 8 && b != 11 && (b < 14 || b > 26) && (b < 28 || b > 31)) continue;
            return true;
        }
        return false;
    }

    private boolean startsWith(byte[] bytes, byte[] lookFor) {
        if (bytes.length < lookFor.length) {
            return false;
        }
        for (int i = 0; i < lookFor.length; ++i) {
            if (bytes[i] == lookFor[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] read(InputStream stream, int maxNb) throws IOException {
        byte[] buffer = new byte[maxNb];
        int nbRead = stream.read(buffer);
        if (nbRead == buffer.length) {
            return buffer;
        }
        return ArrayUtils.subarray(buffer, 0, nbRead);
    }

    protected HtmlPage createHtmlPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        return HTMLParser.parseHtml(webResponse, webWindow);
    }

    protected XHtmlPage createXHtmlPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        return HTMLParser.parseXHtml(webResponse, webWindow);
    }

    protected JavaScriptPage createJavaScriptPage(WebResponse webResponse, WebWindow webWindow) {
        JavaScriptPage newPage = new JavaScriptPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected TextPage createTextPage(WebResponse webResponse, WebWindow webWindow) {
        TextPage newPage = new TextPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected UnexpectedPage createUnexpectedPage(WebResponse webResponse, WebWindow webWindow) {
        UnexpectedPage newPage = new UnexpectedPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected XmlPage createXmlPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        XmlPage newPage = new XmlPage(webResponse, webWindow);
        webWindow.setEnclosedPage(newPage);
        return newPage;
    }

    protected String determinePageType(String contentType) {
        if (contentType.equals("text/html")) {
            return "html";
        }
        if (contentType.equals("text/javascript") || contentType.equals("application/x-javascript")) {
            return "javascript";
        }
        if (contentType.equals("text/xml") || contentType.equals("application/xml") || contentType.equals("text/vnd.wap.wml") || contentType.matches(".*\\+xml")) {
            return "xml";
        }
        if (contentType.startsWith("text/")) {
            return "text";
        }
        return "unknown";
    }
}

