/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.background;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaScriptJobManagerImpl
implements JavaScriptJobManager {
    private static final long serialVersionUID = -8550108829091685593L;
    private final transient WeakReference<WebWindow> window_;
    private final PriorityQueue<JavaScriptJob> scheduledJobsQ_ = new PriorityQueue();
    private final ArrayList<Integer> cancelledJobs_ = new ArrayList();
    private JavaScriptJob currentlyRunningJob_ = null;
    private static final AtomicInteger NEXT_JOB_ID_ = new AtomicInteger(1);
    private static final Log LOG = LogFactory.getLog(JavaScriptJobManagerImpl.class);

    public JavaScriptJobManagerImpl(WebWindow window) {
        this.window_ = new WeakReference<WebWindow>(window);
    }

    public synchronized int getJobCount() {
        return this.scheduledJobsQ_.size() + (this.currentlyRunningJob_ != null ? 1 : 0);
    }

    public synchronized int addJob(JavaScriptJob job, Page page) {
        WebWindow w = this.getWindow();
        if (w == null) {
            return 0;
        }
        if (w.getEnclosedPage() != page) {
            return 0;
        }
        int id = NEXT_JOB_ID_.getAndIncrement();
        job.setId(id);
        this.scheduledJobsQ_.add(job);
        if (LOG.isDebugEnabled()) {
            LOG.debug("\twindow is: " + this.getWindow());
            LOG.debug("\tadded job: " + job.toString());
            LOG.debug("after adding job to the queue, the queue is: ");
            this.printQueue();
        }
        return id;
    }

    public synchronized void removeJob(int id) {
        for (JavaScriptJob job : this.scheduledJobsQ_) {
            if (job.getId() != id) continue;
            this.scheduledJobsQ_.remove(job);
            break;
        }
        this.cancelledJobs_.add(id);
    }

    public synchronized void stopJob(int id) {
        for (JavaScriptJob job : this.scheduledJobsQ_) {
            if (job.getId() != id) continue;
            this.scheduledJobsQ_.remove(job);
            break;
        }
        this.cancelledJobs_.add(id);
    }

    public synchronized void removeAllJobs() {
        if (this.currentlyRunningJob_ != null) {
            this.cancelledJobs_.add(this.currentlyRunningJob_.getId());
        }
        for (JavaScriptJob job : this.scheduledJobsQ_) {
            this.cancelledJobs_.add(job.getId());
        }
        this.scheduledJobsQ_.clear();
    }

    public int waitForJobs(long timeoutMillis) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Waiting for all jobs to finish (will wait max " + timeoutMillis + " millis).");
        }
        if (timeoutMillis > 0L) {
            long start = System.currentTimeMillis();
            long interval = Math.min(timeoutMillis, 100L);
            while (this.getJobCount() > 0 && System.currentTimeMillis() - start < timeoutMillis) {
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    LOG.error("InterruptedException while in waitForJobs");
                }
            }
        }
        int jobs = this.getJobCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished waiting for all jobs to finish (final job count is " + jobs + ").");
        }
        return jobs;
    }

    public int waitForJobsStartingBefore(long delayMillis) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Waiting for all jobs that have execution time before " + delayMillis + " to finish");
        }
        long targetExecutionTime = System.currentTimeMillis() + delayMillis;
        JavaScriptJob earliestJob = this.getEarliestJob();
        JavaScriptJob currentlyRunningJob = this.currentlyRunningJob_;
        while (currentlyRunningJob != null && currentlyRunningJob.getTargetExecutionTime() < targetExecutionTime || earliestJob != null && earliestJob.getTargetExecutionTime() < targetExecutionTime) {
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                LOG.error("InterruptedException while in waitForJobsStartingBefore");
            }
            earliestJob = this.getEarliestJob();
            currentlyRunningJob = this.currentlyRunningJob_;
        }
        int jobs = this.getJobCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished waiting for all jobs that have target execution time earlier than " + targetExecutionTime + ", final job count is " + jobs);
        }
        return jobs;
    }

    public synchronized void shutdown() {
        this.scheduledJobsQ_.clear();
    }

    private WebWindow getWindow() {
        return (WebWindow)this.window_.get();
    }

    private void runJob(JavaScriptJob job) {
        try {
            job.run();
        }
        catch (RuntimeException e) {
            LOG.error("Job run failed with unexpected RuntimeException: " + e.getMessage(), e);
        }
    }

    private void printQueue() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("------ printing JavaScript job queue -----");
            LOG.debug("number of jobs on the queue: " + this.scheduledJobsQ_.size());
            for (JavaScriptJob job : this.scheduledJobsQ_) {
                LOG.debug("\tJob target execution time:" + job.getTargetExecutionTime());
                LOG.debug("\tjob to string: " + job.toString());
                LOG.debug("\tjob id: " + job.getId());
            }
            LOG.debug("------------------------------------------");
        }
    }

    private synchronized boolean setCurrentlyRunningJob(JavaScriptJob job) {
        if (job.getTargetExecutionTime() < System.currentTimeMillis()) {
            if (this.scheduledJobsQ_.remove(job)) {
                this.currentlyRunningJob_ = job;
            }
            return this.currentlyRunningJob_ != null;
        }
        return false;
    }

    public JavaScriptJob getEarliestJob() {
        return this.scheduledJobsQ_.peek();
    }

    public boolean runSingleJob(JavaScriptJob givenJob) {
        String intervalJob;
        boolean isIntervalJob;
        assert (givenJob != null);
        JavaScriptJob job = this.scheduledJobsQ_.peek();
        if (job != givenJob) {
            return false;
        }
        this.setCurrentlyRunningJob(job);
        if (this.currentlyRunningJob_ == null) {
            return false;
        }
        job = this.currentlyRunningJob_;
        boolean bl = isIntervalJob = job.getPeriod() != null;
        if (isIntervalJob) {
            long currentTime = System.currentTimeMillis();
            long timeDifference = currentTime - job.getTargetExecutionTime();
            if (timeDifference % (long)job.getPeriod().intValue() > 0L) {
                timeDifference = timeDifference / (long)job.getPeriod().intValue() * (long)job.getPeriod().intValue() + (long)job.getPeriod().intValue();
            }
            job.setTargetExecutionTime(job.getTargetExecutionTime() + timeDifference);
            if (!this.cancelledJobs_.contains(job.getId())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reschedulling job " + job);
                }
                this.scheduledJobsQ_.add(job);
            }
        }
        String string = intervalJob = isIntervalJob ? "interval " : "";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting " + intervalJob + "job " + job);
        }
        this.runJob(job);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished " + intervalJob + "job " + job);
        }
        this.currentlyRunningJob_ = null;
        return true;
    }
}

