/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.xml;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCDataSection;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentType;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomProcessingInstruction;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.IElementFactory;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public final class XmlUtil {
    private static final Log LOG = LogFactory.getLog(XmlUtil.class);
    private static final ErrorHandler DISCARD_MESSAGES_HANDLER = new ErrorHandler(){

        public void error(SAXParseException exception) {
        }

        public void fatalError(SAXParseException exception) {
        }

        public void warning(SAXParseException exception) {
        }
    };

    private XmlUtil() {
    }

    public static Document buildDocument(WebResponse webResponse) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        InputSource source = new InputSource(new StringReader(webResponse.getContentAsString()));
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(DISCARD_MESSAGES_HANDLER);
        builder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        return builder.parse(source);
    }

    public static void appendChild(SgmlPage page, DomNode parent, Node child) {
        DocumentType documentType = child.getOwnerDocument().getDoctype();
        if (documentType != null && page instanceof XmlPage) {
            DomDocumentType domDoctype = new DomDocumentType(page, documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
            ((XmlPage)page).setDocumentType(domDoctype);
        }
        DomNode childXml = XmlUtil.createFrom(page, child);
        parent.appendChild(childXml);
        XmlUtil.copy(page, child, childXml);
    }

    private static DomNode createFrom(SgmlPage page, Node source) {
        if (source.getNodeType() == 3) {
            return new DomText(page, source.getNodeValue());
        }
        String ns = source.getNamespaceURI();
        String localName = source.getLocalName();
        if ("http://www.w3.org/1999/xhtml".equals(ns)) {
            IElementFactory factory = HTMLParser.getFactory(localName);
            return factory.createElementNS(page, ns, localName, XmlUtil.namedNodeMapToSaxAttributes(source.getAttributes()));
        }
        HashMap<String, DomAttr> attributes = new HashMap<String, DomAttr>();
        NamedNodeMap nodeAttributes = source.getAttributes();
        for (int i = 0; i < nodeAttributes.getLength(); ++i) {
            Attr attribute = (Attr)nodeAttributes.item(i);
            String namespaceURI = attribute.getNamespaceURI();
            String qualifiedName = attribute.getPrefix() != null ? attribute.getPrefix() + ':' + attribute.getLocalName() : attribute.getLocalName();
            String value = attribute.getNodeValue();
            boolean specified = attribute.getSpecified();
            DomAttr xmlAttribute = new DomAttr(page, namespaceURI, qualifiedName, value, specified);
            attributes.put(attribute.getNodeName(), xmlAttribute);
        }
        if (page instanceof HtmlPage) {
            localName = localName.toUpperCase();
        }
        String qualifiedName = source.getPrefix() == null ? localName : source.getPrefix() + ':' + localName;
        return new DomElement(source.getNamespaceURI(), qualifiedName, page, attributes);
    }

    private static Attributes namedNodeMapToSaxAttributes(NamedNodeMap attributesMap) {
        AttributesImpl attributes = new AttributesImpl();
        int length = attributesMap.getLength();
        for (int i = 0; i < length; ++i) {
            Node attr = attributesMap.item(i);
            attributes.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getNodeName(), null, attr.getNodeValue());
        }
        return attributes;
    }

    private static void copy(SgmlPage page, Node source, DomNode dest) {
        NodeList nodeChildren = source.getChildNodes();
        block7: for (int i = 0; i < nodeChildren.getLength(); ++i) {
            Node child = nodeChildren.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    DomNode childXml = XmlUtil.createFrom(page, child);
                    dest.appendChild(childXml);
                    XmlUtil.copy(page, child, childXml);
                    continue block7;
                }
                case 3: {
                    dest.appendChild(new DomText(page, child.getNodeValue()));
                    continue block7;
                }
                case 4: {
                    dest.appendChild(new DomCDataSection(page, child.getNodeValue()));
                    continue block7;
                }
                case 8: {
                    dest.appendChild(new DomComment(page, child.getNodeValue()));
                    continue block7;
                }
                case 7: {
                    dest.appendChild(new DomProcessingInstruction(page, child.getNodeName(), child.getNodeValue()));
                    continue block7;
                }
                default: {
                    LOG.warn("NodeType " + child.getNodeType() + " (" + child.getNodeName() + ") is not yet supported.");
                }
            }
        }
    }

    public static String lookupNamespaceURI(DomElement element, String prefix) {
        DomNode parentNode;
        String uri = element.getAttribute("xmlns:" + prefix);
        if (uri == DomElement.ATTRIBUTE_NOT_DEFINED && (parentNode = element.getParentNode()) instanceof DomElement) {
            uri = XmlUtil.lookupNamespaceURI((DomElement)parentNode, prefix);
        }
        return uri;
    }

    public static String lookupPrefix(DomElement element, String namespace) {
        Map<String, DomAttr> attributes = element.getAttributesMap();
        for (String name : attributes.keySet()) {
            if (!name.startsWith("xmlns:") || !attributes.get(name).getValue().equals(namespace)) continue;
            return name.substring(6);
        }
        for (DomNode child : element.getChildren()) {
            String prefix;
            if (!(child instanceof DomElement) || (prefix = XmlUtil.lookupPrefix((DomElement)child, namespace)) == null) continue;
            return prefix;
        }
        return null;
    }
}

