/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal;

import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.cactus.internal.client.ClientTestCaseCaller;
import org.apache.cactus.internal.configuration.ConfigurationInitializer;
import org.apache.cactus.internal.server.ServerTestCaseCaller;
import org.apache.cactus.internal.util.TestCaseImplementChecker;
import org.apache.cactus.spi.client.connector.ProtocolHandler;

public abstract class AbstractCactusTestCase
extends TestCase {
    private ClientTestCaseCaller clientCaller;
    private ServerTestCaseCaller serverCaller;

    static {
        ConfigurationInitializer.initialize();
    }

    protected abstract ProtocolHandler createProtocolHandler();

    public AbstractCactusTestCase() {
        this.init(null);
    }

    public AbstractCactusTestCase(String theName) {
        super(theName);
        this.init(null);
    }

    public AbstractCactusTestCase(String theName, Test theTest) {
        super(theName);
        this.init(theTest);
    }

    public void runBare() throws Throwable {
        TestCaseImplementChecker.checkTestName(this);
        TestCaseImplementChecker.checkTestName(this.getServerCaller().getWrappedTest());
        this.runBareClient();
    }

    public void runBareServer() throws Throwable {
        this.getServerCaller().runBareInit();
        if (this.getServerCaller().getWrappedTest() != null) {
            ((TestCase)this.getServerCaller().getWrappedTest()).runBare();
        } else {
            super.runBare();
        }
    }

    private void setClientCaller(ClientTestCaseCaller theCaller) {
        this.clientCaller = theCaller;
    }

    private void setServerCaller(ServerTestCaseCaller theCaller) {
        this.serverCaller = theCaller;
    }

    private ClientTestCaseCaller getClientCaller() {
        return this.clientCaller;
    }

    private ServerTestCaseCaller getServerCaller() {
        return this.serverCaller;
    }

    private void init(Test theTest) {
        this.setClientCaller(new ClientTestCaseCaller(this, theTest, this.createProtocolHandler()));
        this.setServerCaller(new ServerTestCaseCaller(this, theTest));
    }

    private void runBareClient() throws Throwable {
        this.getClientCaller().runBareInit();
        try {
            this.getClientCaller().runTest();
        }
        catch (Throwable t) {
            this.getClientCaller().getLogger().debug("Exception in test", t);
            throw t;
        }
    }
}

