/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.orion;

import java.io.File;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.internal.util.AntBuildListener;
import org.codehaus.cargo.container.internal.util.AntUtils;
import org.codehaus.cargo.container.spi.DeployerWatchdog;
import org.codehaus.cargo.util.monitor.MonitoredObject;

public class OrionDeployer
extends MonitoredObject
implements Deployer {
    private Container container;
    private AntUtils antUtils;

    public OrionDeployer(Container container) {
        this.container = container;
        this.antUtils = new AntUtils();
        this.setMonitor(container.getMonitor());
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected Container getContainer() {
        return this.container;
    }

    public void deploy(Deployable deployable, DeployableMonitor monitor) {
        this.deploy(deployable);
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setMonitor(this.getMonitor());
        watchdog.waitForDeployment();
    }

    public void deploy(Deployable deployable) {
        if (deployable instanceof EAR) {
            this.deployEAR((EAR)deployable);
        } else {
            this.deployWAR((WAR)deployable);
        }
    }

    private void deployWAR(WAR deployable) {
        throw new ContainerException("Not supported");
    }

    private void deployEAR(EAR deployable) {
        Java java = this.createAdminCommand();
        java.createArg().setValue("-deploy");
        java.createArg().setFile(deployable.getFile());
        java.createArg().setValue("-deploymentName");
        java.createArg().setValue(deployable.getName());
        java.createArg().setValue("-cluster");
        java.createArg().setValue("-ignorePreviousDeployment");
        java.execute();
    }

    private Java createAdminCommand() {
        Java java = (Java)this.getAntUtils().createAntTask("java");
        java.setFork(true);
        java.getProject().addBuildListener((BuildListener)new AntBuildListener(this.getMonitor(), this.getClass().getName()));
        Path classpath = java.createClasspath();
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.getContainer().getHomeDir());
        fileSet.createInclude().setName("admin.jar");
        classpath.addFileset(fileSet);
        java.setJar(new File(this.getContainer().getHomeDir(), "admin.jar"));
        String serverURL = "ormi://" + this.getContainer().getConfiguration().getPropertyValue("cargo.hostname") + ":" + this.getContainer().getConfiguration().getPropertyValue("cargo.orion.rmi.port") + "/";
        java.createArg().setValue(serverURL);
        java.createArg().setValue("cargo");
        java.createArg().setValue("cargo");
        return java;
    }

    public void start(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void stop(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void undeploy(Deployable deployable) {
        throw new ContainerException("Not supported");
    }
}

