/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.richclient;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import java.io.IOException;
import java.util.List;
import org.jboss.jsfunit.jsfsession.ComponentIDNotFoundException;
import org.jboss.jsfunit.jsfsession.JSFClientSession;

public class RichFacesClient {
    private JSFClientSession jsfClient;

    public RichFacesClient(JSFClientSession jsfClient) {
        this.jsfClient = jsfClient;
    }

    public void setDataFilterSlider(String componentID, String value) {
        this.jsfClient.setValue(componentID + "slider_val", value);
    }

    public void setCalendarValue(String componentID, String value) throws IOException {
        this.jsfClient.setValue(componentID + "InputDate", value);
    }

    public void setInplaceInput(String componentID, String value, String customSaveID) throws IOException {
        HtmlSpan span = (HtmlSpan)this.jsfClient.getElement(componentID);
        HtmlTextInput input = (HtmlTextInput)this.jsfClient.getElement(componentID + "tempValue");
        span.click();
        input.type(value);
        if (customSaveID != null) {
            HtmlButton saveButton = (HtmlButton)this.jsfClient.getElement(customSaveID);
            saveButton.click();
        } else {
            HtmlDivision bar = (HtmlDivision)this.jsfClient.getElement(componentID + "bar");
            String buttonStyle = bar.getAttribute("style");
            if (buttonStyle.contains("display:none") || buttonStyle.contains("display: none")) {
                input.blur();
            } else {
                HtmlImageInput okButton = (HtmlImageInput)this.jsfClient.getElement(componentID + "ok");
                okButton.fireEvent("mousedown");
            }
        }
    }

    public void setInplaceInput(String componentID, String value) throws IOException {
        this.setInplaceInput(componentID, value, null);
    }

    public void clickTreeNodeHandle(String treeNodeKey, String treeNodeId) throws IOException {
        String handleId = ":" + treeNodeKey + "::" + treeNodeId + ":handle";
        HtmlElement icon = (HtmlElement)this.jsfClient.getElement(handleId);
        if (icon == null) {
            throw new ComponentIDNotFoundException(handleId);
        }
        icon.click();
    }

    public void dragAndDrop(String dragComponentID, String dropTargetComponentID) throws IOException {
        HtmlElement dragElement = (HtmlElement)this.jsfClient.getElement(dragComponentID);
        HtmlPage htmlPage = (HtmlPage)dragElement.mouseDown();
        HtmlElement bodyElement = (HtmlElement)htmlPage.getFirstByXPath("//body");
        if (bodyElement == null) {
            throw new ComponentIDNotFoundException("Can't drag and drop on a page without a body.");
        }
        bodyElement.mouseMove();
        HtmlElement dropElement = (HtmlElement)this.jsfClient.getElement(dropTargetComponentID);
        dropElement.mouseOver();
        dropElement.mouseMove();
        dropElement.mouseUp();
    }

    public void clickTab(String tabComponentID) throws IOException {
        HtmlElement tab = (HtmlElement)this.jsfClient.getElement(tabComponentID + "_shifted");
        tab.click();
    }

    public void setComboBox(String componentID, String value) throws IOException {
        this.jsfClient.setValue(componentID + "comboboxValue", value);
    }

    public void setInputNumberSpinner(String componentID, String value) throws IOException {
        DomNode tdTag = (DomNode)((Object)this.jsfClient.getElement(componentID + "Edit"));
        HtmlInput input = (HtmlInput)tdTag.getChildNodes().item(0);
        input.setValueAttribute(value);
    }

    public void clickInputNumberSpinnerUp(String componentID) throws IOException {
        this.clickSpinnerButton(componentID, "SpinnerButtonUp");
    }

    public void clickInputNumberSpinnerDown(String componentID) throws IOException {
        this.clickSpinnerButton(componentID, "SpinnerButtonDown");
    }

    private void clickSpinnerButton(String componentID, String imageName) throws IOException {
        DomNode table = (DomNode)((Object)this.jsfClient.getElement(componentID + "Buttons"));
        List<?> inputs = table.getByXPath("tbody/tr/td/input");
        for (HtmlInput input : inputs) {
            if (!input.asXml().contains(imageName)) continue;
            input.click();
            return;
        }
        throw new RuntimeException("Can't find image for " + imageName);
    }

    public void setInputNumberSlider(String componentID, String value) throws IOException {
        HtmlInput input = (HtmlInput)this.jsfClient.getElement(componentID + "Input");
        input.setValueAttribute(value);
    }

    public HtmlElement getTreeHandle(String treeID, String treeNodeID, String nodeText) throws IOException {
        String xpath;
        DomNode table = (DomNode)((Object)this.jsfClient.getElement(treeID));
        HtmlElement foundElement = (HtmlElement)table.getFirstByXPath(xpath = "//text()[. = '" + nodeText + "']/ancestor::*" + "/tr[contains(@id, ':" + treeNodeID + ":')]/descendant::*" + "/a[@class='rich-tree-node-handle'][contains(@id, ':" + treeNodeID + ":')]");
        if (foundElement != null) {
            return foundElement;
        }
        xpath = "//text()[. = '" + nodeText + "']/ancestor::*" + "/self::node()[namespace-uri()='http://www.w3.org/1999/xhtml'][local-name()='tr'][contains(@id, ':" + treeNodeID + ":')]/descendant::*" + "/self::node()[namespace-uri()='http://www.w3.org/1999/xhtml'][local-name()='a'][@class='rich-tree-node-handle'][contains(@id, ':" + treeNodeID + ":')]";
        return (HtmlElement)table.getFirstByXPath(xpath);
    }

    public boolean isTreeHandleExpanded(String treeID, String treeNodeID, String nodeText) throws IOException {
        HtmlElement treeHandle = this.getTreeHandle(treeID, treeNodeID, nodeText);
        if (treeHandle == null) {
            return false;
        }
        String classValue = treeHandle.getAttribute("class");
        if (classValue == null || !classValue.equals("rich-tree-node-handle")) {
            throw new IllegalArgumentException("treeHandle element is not a RichFaces tree node handle: " + treeHandle.asXml());
        }
        String handleXpath = treeHandle.getCanonicalXPath();
        String imgXpath = handleXpath + "/img[@class='rich-tree-node-handleicon-expanded'][contains(@style, 'display: none;')]";
        HtmlElement img = (HtmlElement)treeHandle.getFirstByXPath(imgXpath);
        if (img != null) {
            return false;
        }
        imgXpath = handleXpath + "/child::*/self::node()[namespace-uri()='http://www.w3.org/1999/xhtml'][local-name()='img']" + "[@class='rich-tree-node-handleicon-expanded'][contains(@style, 'display: none;')]";
        img = (HtmlElement)treeHandle.getFirstByXPath(imgXpath);
        return img == null;
    }

    public HtmlElement getTreeNodeByText(String treeID, String componentID, String nodeText) throws IOException {
        DomNode table = (DomNode)((Object)this.jsfClient.getElement(treeID));
        String xpath = "//text()[. = '" + nodeText + "']/parent::*[contains(@id,'" + treeID + "')][contains(@id,'" + componentID + "')]";
        return (HtmlElement)table.getFirstByXPath(xpath);
    }
}

