/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.InputElementFactory;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.javascript.host.FormField;
import org.apache.commons.lang.math.NumberUtils;
import org.xml.sax.helpers.AttributesImpl;

public class HTMLInputElement
extends FormField {
    private static final long serialVersionUID = 3712016051364495710L;

    public void jsConstructor() {
    }

    public void jsxSet_type(String newType) {
        HtmlInput input = this.getHtmlInputOrDie();
        if (!input.getTypeAttribute().equalsIgnoreCase(newType)) {
            AttributesImpl attributes = this.readAttributes(input);
            int index = attributes.getIndex("type");
            attributes.setValue(index, newType);
            HtmlInput newInput = (HtmlInput)InputElementFactory.instance.createElement(input.getPage(), "input", attributes);
            if (input.getParentNode() != null) {
                input.getParentNode().replaceChild(newInput, input);
            } else {
                input = newInput;
            }
            input.setScriptObject(null);
            this.setDomNode(newInput, true);
        }
    }

    public void jsxSet_checked(boolean checked) {
        ((HtmlInput)this.getDomNodeOrDie()).setChecked(checked);
    }

    protected HtmlInput getHtmlInputOrDie() {
        return (HtmlInput)this.getDomNodeOrDie();
    }

    public boolean jsxGet_checked() {
        return ((HtmlInput)this.getDomNodeOrDie()).isChecked();
    }

    public void jsxFunction_select() {
        HtmlInput input = this.getHtmlInputOrDie();
        if (input instanceof HtmlTextInput) {
            ((HtmlTextInput)this.getDomNodeOrDie()).select();
        }
    }

    public void jsxFunction_setAttribute(String name, String value) {
        if ("type".equals(name)) {
            this.jsxSet_type(value);
        } else {
            super.jsxFunction_setAttribute(name, value);
        }
    }

    public String jsxGet_defaultValue() {
        return ((HtmlInput)this.getDomNodeOrDie()).getDefaultValue();
    }

    public void jsxSet_defaultValue(String defaultValue) {
        ((HtmlInput)this.getDomNodeOrDie()).setDefaultValue(defaultValue);
    }

    public boolean jsxGet_defaultChecked() {
        return ((HtmlInput)this.getDomNodeOrDie()).isDefaultChecked();
    }

    public void jsxSet_defaultChecked(boolean defaultChecked) {
        ((HtmlInput)this.getDomNodeOrDie()).setDefaultChecked(defaultChecked);
    }

    public int jsxGet_textLength() {
        return this.jsxGet_value().length();
    }

    public int jsxGet_selectionStart() {
        return ((SelectableTextInput)((Object)this.getDomNodeOrDie())).getSelectionStart();
    }

    public void jsxSet_selectionStart(int start) {
        ((SelectableTextInput)((Object)this.getDomNodeOrDie())).setSelectionStart(start);
    }

    public int jsxGet_selectionEnd() {
        return ((SelectableTextInput)((Object)this.getDomNodeOrDie())).getSelectionEnd();
    }

    public void jsxSet_selectionEnd(int end) {
        ((SelectableTextInput)((Object)this.getDomNodeOrDie())).setSelectionEnd(end);
    }

    protected boolean isAttributeName(String name) {
        if ("maxlength".equals(name.toLowerCase())) {
            return "maxLength".equals(name);
        }
        if ("readOnly".equals(name.toLowerCase())) {
            return "readOnly".equals(name);
        }
        return super.isAttributeName(name);
    }

    public int jsxGet_maxLength() {
        String attrValue = this.getDomNodeOrDie().getAttribute("maxLength");
        return NumberUtils.toInt(attrValue, -1);
    }

    public void jsxSet_maxLength(int length) {
        this.getDomNodeOrDie().setAttribute("maxLength", String.valueOf(length));
    }

    public boolean jsxGet_readOnly() {
        return ((HtmlInput)this.getDomNodeOrDie()).isReadOnly();
    }

    public void jsxSet_readOnly(boolean readOnly) {
        ((HtmlInput)this.getDomNodeOrDie()).setReadOnly(readOnly);
    }

    public void jsxFunction_setSelectionRange(int start, int end) {
        this.jsxSet_selectionStart(start);
        this.jsxSet_selectionEnd(end);
    }

    public String jsxGet_alt() {
        String alt = this.getDomNodeOrDie().getAttribute("alt");
        if (alt == NOT_FOUND) {
            alt = "";
        }
        return alt;
    }

    public void jsxSet_alt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    public String jsxGet_border() {
        String border = this.getDomNodeOrDie().getAttribute("border");
        if (border == NOT_FOUND) {
            border = "";
        }
        return border;
    }

    public void jsxSet_border(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    public String jsxGet_align() {
        return this.getAlign(true);
    }

    public void jsxSet_align(String align) {
        boolean ignoreIfNoError = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_84);
        this.setAlign(align, ignoreIfNoError);
    }
}

