/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.javascript.host.FormField;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLOptionElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLOptionsCollection;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

public class HTMLSelectElement
extends FormField {
    private static final long serialVersionUID = 4332789476842114628L;
    private HTMLOptionsCollection optionsArray_;

    public void jsConstructor() {
    }

    public void initialize() {
        HtmlSelect htmlSelect = this.getHtmlSelect();
        htmlSelect.setScriptObject(this);
        if (this.optionsArray_ == null) {
            this.optionsArray_ = new HTMLOptionsCollection(this);
            this.optionsArray_.initialize(htmlSelect);
        }
    }

    public void jsxFunction_remove(int index) {
        this.put(index, null, null);
    }

    public void jsxFunction_add(HTMLOptionElement newOptionObject, Object arg2) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_89)) {
            this.add_IE(newOptionObject, arg2);
        } else {
            this.add(newOptionObject, arg2);
        }
        this.ensureSelectedIndex();
    }

    public Object jsxFunction_appendChild(Object childObject) {
        Object object = super.jsxFunction_appendChild(childObject);
        this.ensureSelectedIndex();
        return object;
    }

    public Object jsxFunction_insertBefore(Object[] args) {
        Object object = super.jsxFunction_insertBefore(args);
        this.ensureSelectedIndex();
        return object;
    }

    protected void add_IE(HTMLOptionElement newOptionObject, Object index) {
        int intIndex;
        HtmlSelect select = this.getHtmlSelect();
        HtmlOption beforeOption = Context.getUndefinedValue().equals(index) ? null : ((intIndex = ((Integer)Context.jsToJava(index, Integer.class)).intValue()) >= select.getOptionSize() ? null : select.getOption(intIndex));
        this.addBefore(newOptionObject, beforeOption);
    }

    protected void add(HTMLOptionElement newOptionObject, Object beforeOptionObject) {
        HtmlOption beforeOption;
        if (beforeOptionObject == null) {
            beforeOption = null;
        } else {
            if (Context.getUndefinedValue().equals(beforeOptionObject)) {
                throw Context.reportRuntimeError("Not enough arguments [SelectElement.add]");
            }
            beforeOption = (HtmlOption)((HTMLOptionElement)beforeOptionObject).getDomNodeOrDie();
        }
        this.addBefore(newOptionObject, beforeOption);
    }

    protected void addBefore(HTMLOptionElement newOptionObject, HtmlOption beforeOption) {
        HtmlSelect select = this.getHtmlSelect();
        HtmlOption htmlOption = newOptionObject.getDomNodeOrNull();
        if (htmlOption == null) {
            htmlOption = (HtmlOption)HTMLParser.getFactory("option").createElement(select.getPage(), "option", null);
        }
        if (beforeOption == null) {
            select.appendChild(htmlOption);
        } else {
            beforeOption.insertBefore(htmlOption);
        }
    }

    public String jsxGet_type() {
        String type = this.getHtmlSelect().isMultipleSelectEnabled() ? "select-multiple" : "select-one";
        return type;
    }

    public HTMLOptionsCollection jsxGet_options() {
        if (this.optionsArray_ == null) {
            this.initialize();
        }
        return this.optionsArray_;
    }

    public int jsxGet_selectedIndex() {
        HtmlSelect htmlSelect = this.getHtmlSelect();
        List<HtmlOption> selectedOptions = htmlSelect.getSelectedOptions();
        if (selectedOptions.isEmpty()) {
            return -1;
        }
        List<HtmlOption> allOptions = htmlSelect.getOptions();
        return allOptions.indexOf(selectedOptions.get(0));
    }

    public void jsxSet_selectedIndex(int index) {
        HtmlSelect htmlSelect = this.getHtmlSelect();
        if (index != 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_171) && (index < -1 || index >= htmlSelect.getOptionSize())) {
            throw Context.reportRuntimeError("Invalid index for select node: " + index);
        }
        for (HtmlOption itemToUnSelect : htmlSelect.getSelectedOptions()) {
            htmlSelect.setSelectedAttribute(itemToUnSelect, false);
        }
        if (index < 0) {
            return;
        }
        List<HtmlOption> allOptions = htmlSelect.getOptions();
        if (index < allOptions.size()) {
            HtmlOption itemToSelect = allOptions.get(index);
            htmlSelect.setSelectedAttribute(itemToSelect, true, false);
        }
    }

    public String jsxGet_value() {
        HtmlSelect htmlSelect = this.getHtmlSelect();
        List<HtmlOption> selectedOptions = htmlSelect.getSelectedOptions();
        if (selectedOptions.isEmpty()) {
            return "";
        }
        return ((HTMLOptionElement)selectedOptions.get(0).getScriptObject()).jsxGet_value();
    }

    public int jsxGet_length() {
        if (this.optionsArray_ == null) {
            this.initialize();
        }
        return this.optionsArray_.jsxGet_length();
    }

    public void jsxSet_length(int newLength) {
        if (this.optionsArray_ == null) {
            this.initialize();
        }
        this.optionsArray_.jsxSet_length(newLength);
    }

    public Object get(int index, Scriptable start) {
        if (this.optionsArray_ == null) {
            this.initialize();
        }
        return this.optionsArray_.get(index, start);
    }

    public void put(int index, Scriptable start, Object newValue) {
        if (this.optionsArray_ == null) {
            this.initialize();
        }
        this.optionsArray_.put(index, start, newValue);
    }

    private HtmlSelect getHtmlSelect() {
        return (HtmlSelect)this.getDomNodeOrDie();
    }

    public void jsxSet_value(String newValue) {
        this.getHtmlSelect().setSelectedAttribute(newValue, true);
    }

    public int jsxGet_size() {
        int size = 0;
        String sizeAttribute = this.getDomNodeOrDie().getAttribute("size");
        if (sizeAttribute != HtmlSelect.ATTRIBUTE_NOT_DEFINED && sizeAttribute != HtmlSelect.ATTRIBUTE_VALUE_EMPTY) {
            try {
                size = Integer.parseInt(sizeAttribute);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return size;
    }

    public void jsxSet_size(String size) {
        this.getDomNodeOrDie().setAttribute("size", size);
    }

    public boolean jsxGet_multiple() {
        return this.getDomNodeOrDie().hasAttribute("multiple");
    }

    public void jsxSet_multiple(boolean multiple) {
        if (multiple) {
            this.getDomNodeOrDie().setAttribute("multiple", "multiple");
        } else {
            this.getDomNodeOrDie().removeAttribute("multiple");
        }
    }

    private void ensureSelectedIndex() {
        HtmlSelect select = this.getHtmlSelect();
        if (select.getOptionSize() == 0) {
            this.jsxSet_selectedIndex(-1);
        } else if (this.jsxGet_selectedIndex() == -1) {
            this.jsxSet_selectedIndex(0);
        }
    }
}

