/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.WebAssert;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    private static final Log LOG = LogFactory.getLog(StringUtils.class);

    private StringUtils() {
    }

    public static String escapeXmlChars(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static boolean containsWhitespace(String s) {
        for (char c : s.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(String s, char searchChar, int beginIndex, int endIndex) {
        for (int i = beginIndex; i < endIndex; ++i) {
            if (s.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static boolean isFloat(String s, boolean trim) {
        boolean ok;
        if (trim) {
            s = s.trim();
        }
        try {
            Float.parseFloat(s);
            ok = true;
        }
        catch (NumberFormatException e) {
            ok = false;
        }
        return ok;
    }

    public static boolean containsCaseInsensitive(Collection<String> strings, String string) {
        string = string.toLowerCase();
        for (String s : strings) {
            if (!s.toLowerCase().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static Date parseHttpDate(String s) {
        if (s == null) {
            return null;
        }
        try {
            return DateUtils.parseDate(s);
        }
        catch (DateParseException e) {
            LOG.warn("Unable to parse date: " + s);
            return null;
        }
    }

    public static String formatHttpDate(Date date) {
        WebAssert.notNull("date", date);
        return DateUtils.formatDate(date);
    }
}

