/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi;

import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.DeployableMonitorListener;
import org.codehaus.cargo.util.monitor.MonitoredObject;

public class DeployerWatchdog
extends MonitoredObject
implements DeployableMonitorListener {
    private DeployableMonitor monitor;
    private boolean isDeployed;

    public DeployerWatchdog(DeployableMonitor monitor) {
        this.monitor = monitor;
        monitor.registerListener(this);
    }

    public void deployed() {
        this.isDeployed = true;
    }

    public void waitForDeployment() {
        try {
            long startTime = System.currentTimeMillis();
            do {
                if (System.currentTimeMillis() - startTime > this.monitor.getTimeout()) {
                    String message = "Deployable failed to finish deploying within the timeout period [" + this.monitor.getTimeout() + "]. The Deployable state is thus unknown.";
                    this.getMonitor().info(message, this.getClass().getName());
                    throw new ContainerException(message);
                }
                Thread.sleep(100L);
                this.monitor.monitor();
            } while (!this.isDeployed);
        }
        catch (InterruptedException e) {
            throw new ContainerException("Failed to monitor deployment", e);
        }
    }
}

