/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.webapp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.cargo.module.Dtd;
import org.codehaus.cargo.module.webapp.AbstractDescriptor;
import org.codehaus.cargo.module.webapp.AbstractDescriptorTag;
import org.codehaus.cargo.module.webapp.VendorWebAppDescriptor;
import org.codehaus.cargo.module.webapp.WebXmlTag;
import org.codehaus.cargo.module.webapp.WebXmlVersion;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebXml
extends AbstractDescriptor {
    private List vendorDescriptors = new ArrayList();

    public WebXml(Document document) {
        super(document, new Dtd("http://java.sun.com/dtd/web-app_2_3.dtd"));
    }

    public void addVendorDescriptor(VendorWebAppDescriptor descr) {
        this.vendorDescriptors.add(descr);
    }

    public Iterator getVendorDescriptors() {
        return this.vendorDescriptors.iterator();
    }

    public VendorWebAppDescriptor getVendorDescriptor() {
        VendorWebAppDescriptor descr = null;
        if (this.vendorDescriptors.size() > 0) {
            descr = (VendorWebAppDescriptor)this.vendorDescriptors.get(0);
        }
        return descr;
    }

    public final WebXmlVersion getVersion() {
        DocumentType docType = this.getDocument().getDoctype();
        if (docType != null) {
            return WebXmlVersion.valueOf(docType);
        }
        return null;
    }

    public final void addFilter(String filterName, String filterClass) {
        if (filterName == null) {
            throw new NullPointerException();
        }
        if (this.hasFilter(filterName)) {
            throw new IllegalStateException("Filter '" + filterName + "' already defined");
        }
        Element filterElement = this.getDocument().createElement(WebXmlTag.FILTER.getTagName());
        filterElement.appendChild(this.createNestedText(WebXmlTag.FILTER_NAME, filterName));
        filterElement.appendChild(this.createNestedText(WebXmlTag.FILTER_CLASS, filterClass));
        this.addElement(WebXmlTag.FILTER, filterElement, this.getRootElement());
    }

    public final void addContextParam(Element contextParam) {
        this.checkElement(contextParam, WebXmlTag.CONTEXT_PARAM);
        String paramName = this.getNestedText(contextParam, WebXmlTag.PARAM_NAME);
        if (paramName == null) {
            throw new IllegalArgumentException("Not a valid context-param name element");
        }
        String paramValue = this.getNestedText(contextParam, WebXmlTag.PARAM_VALUE);
        if (paramValue == null) {
            throw new IllegalArgumentException("Not a valid context-param value element");
        }
        if (this.hasContextParam(paramName)) {
            throw new IllegalStateException("Context param '" + paramName + "' already defined");
        }
        this.addElement(WebXmlTag.CONTEXT_PARAM, contextParam, this.getRootElement());
    }

    public final void addFilter(Element filter) {
        this.checkElement(filter, WebXmlTag.FILTER);
        String filterName = this.getNestedText(filter, WebXmlTag.FILTER_NAME);
        if (filterName == null) {
            throw new IllegalArgumentException("Not a valid filter element");
        }
        if (this.hasFilter(filterName)) {
            throw new IllegalStateException("Filter '" + filterName + "' already defined");
        }
        this.addElement(WebXmlTag.FILTER, filter, this.getRootElement());
    }

    public final void addFilterInitParam(String filterName, String paramName, String paramValue) {
        Element filterElement = this.getFilter(filterName);
        if (filterElement == null) {
            throw new IllegalStateException("Filter '" + filterName + "' not defined");
        }
        this.addInitParam(filterElement, paramName, paramValue);
    }

    public final void addFilterMapping(String filterName, String urlPattern) {
        if (!this.hasFilter(filterName)) {
            throw new IllegalStateException("Filter '" + filterName + "' not defined");
        }
        Element filterMappingElement = this.getDocument().createElement(WebXmlTag.FILTER_MAPPING.getTagName());
        filterMappingElement.appendChild(this.createNestedText(WebXmlTag.FILTER_NAME, filterName));
        filterMappingElement.appendChild(this.createNestedText(WebXmlTag.URL_PATTERN, urlPattern));
        this.addElement(WebXmlTag.FILTER_MAPPING, filterMappingElement, this.getRootElement());
    }

    public final Element getFilter(String filterName) {
        if (filterName == null) {
            throw new NullPointerException();
        }
        Iterator filterElements = this.getElements(WebXmlTag.FILTER);
        while (filterElements.hasNext()) {
            Element filterElement = (Element)filterElements.next();
            if (!filterName.equals(this.getNestedText(filterElement, WebXmlTag.FILTER_NAME))) continue;
            return filterElement;
        }
        return null;
    }

    public final Element getContextParam(String paramName) {
        if (paramName == null) {
            throw new NullPointerException();
        }
        Iterator contextParamElements = this.getElements(WebXmlTag.CONTEXT_PARAM);
        while (contextParamElements.hasNext()) {
            Element contextParamElement = (Element)contextParamElements.next();
            if (!paramName.equals(this.getNestedText(contextParamElement, WebXmlTag.PARAM_NAME))) continue;
            return contextParamElement;
        }
        return null;
    }

    public final String getContextParamName(Element contextParam) {
        return this.getNestedText(contextParam, WebXmlTag.PARAM_NAME);
    }

    public final Iterator getFilterNamesForClass(String className) {
        if (className == null) {
            throw new NullPointerException();
        }
        Iterator filterElements = this.getElements(WebXmlTag.FILTER);
        ArrayList<String> filterNames = new ArrayList<String>();
        while (filterElements.hasNext()) {
            Element filterElement = (Element)filterElements.next();
            if (!className.equals(this.getNestedText(filterElement, WebXmlTag.FILTER_CLASS))) continue;
            filterNames.add(this.getNestedText(filterElement, WebXmlTag.FILTER_NAME));
        }
        return filterNames.iterator();
    }

    public final String getFilterInitParam(String filterName, String paramName) {
        return this.getInitParam(this.getFilter(filterName), paramName);
    }

    public final Iterator getFilterInitParamNames(String theFilterName) {
        return this.getInitParamNames(this.getFilter(theFilterName));
    }

    public final Iterator getFilterMappings(String theFilterName) {
        if (theFilterName == null) {
            throw new NullPointerException();
        }
        ArrayList<String> filterMappings = new ArrayList<String>();
        Iterator filterMappingElements = this.getElements(WebXmlTag.FILTER_MAPPING);
        while (filterMappingElements.hasNext()) {
            String urlPattern;
            Element filterMappingElement = (Element)filterMappingElements.next();
            if (!theFilterName.equals(this.getNestedText(filterMappingElement, WebXmlTag.FILTER_NAME)) || (urlPattern = this.getNestedText(filterMappingElement, WebXmlTag.URL_PATTERN)) == null) continue;
            filterMappings.add(urlPattern);
        }
        return filterMappings.iterator();
    }

    public final Iterator getFilterNames() {
        ArrayList<String> filterNames = new ArrayList<String>();
        Iterator filterElements = this.getElements(WebXmlTag.FILTER);
        while (filterElements.hasNext()) {
            Element filterElement = (Element)filterElements.next();
            String filterName = this.getNestedText(filterElement, WebXmlTag.FILTER_NAME);
            if (filterName == null) continue;
            filterNames.add(filterName);
        }
        return filterNames.iterator();
    }

    public final boolean hasContextParam(String theParamName) {
        return this.getContextParam(theParamName) != null;
    }

    public final boolean hasFilter(String theFilterName) {
        return this.getFilter(theFilterName) != null;
    }

    public final void addJspFile(String theServletName, String theJspFile) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        if (this.hasFilter(theServletName)) {
            throw new IllegalStateException("Servlet '" + theServletName + "' already defined");
        }
        Element servletElement = this.getDocument().createElement(WebXmlTag.SERVLET.getTagName());
        servletElement.appendChild(this.createNestedText(WebXmlTag.SERVLET_NAME, theServletName));
        servletElement.appendChild(this.createNestedText(WebXmlTag.JSP_FILE, theJspFile));
        this.addElement(WebXmlTag.SERVLET, servletElement, this.getRootElement());
    }

    public final void addServlet(String theServletName, String theServletClass) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        if (this.hasServlet(theServletName)) {
            throw new IllegalStateException("Servlet '" + theServletName + "' already defined");
        }
        Element servletElement = this.getDocument().createElement(WebXmlTag.SERVLET.getTagName());
        servletElement.appendChild(this.createNestedText(WebXmlTag.SERVLET_NAME, theServletName));
        servletElement.appendChild(this.createNestedText(WebXmlTag.SERVLET_CLASS, theServletClass));
        this.addElement(WebXmlTag.SERVLET, servletElement, this.getRootElement());
    }

    public final void addServlet(Element theServlet) {
        this.checkElement(theServlet, WebXmlTag.SERVLET);
        String servletName = this.getNestedText(theServlet, WebXmlTag.SERVLET_NAME);
        if (servletName == null) {
            throw new IllegalArgumentException("Not a valid servlet element");
        }
        if (this.hasServlet(servletName)) {
            throw new IllegalStateException("Servlet '" + servletName + "' already defined");
        }
        this.addElement(WebXmlTag.SERVLET, theServlet, this.getRootElement());
    }

    public final void addServletInitParam(String theServletName, String theParamName, String theParamValue) {
        Element servletElement = this.getServlet(theServletName);
        if (servletElement == null) {
            throw new IllegalStateException("Servlet '" + theServletName + "' not defined");
        }
        this.addInitParam(servletElement, theParamName, theParamValue);
    }

    public final void addServletRunAsRoleName(String theServletName, String theRoleName) {
        Element servlet = this.getServlet(theServletName);
        Element runAsElement = this.getDocument().createElement(WebXmlTag.RUN_AS.getTagName());
        runAsElement.appendChild(this.createNestedText(WebXmlTag.ROLE_NAME, theRoleName));
        servlet.appendChild(runAsElement);
    }

    public final void addServletMapping(String theServletName, String theUrlPattern) {
        if (!this.hasServlet(theServletName)) {
            throw new IllegalStateException("Servlet '" + theServletName + "' not defined");
        }
        Element servletMappingElement = this.getDocument().createElement(WebXmlTag.SERVLET_MAPPING.getTagName());
        servletMappingElement.appendChild(this.createNestedText(WebXmlTag.SERVLET_NAME, theServletName));
        servletMappingElement.appendChild(this.createNestedText(WebXmlTag.URL_PATTERN, theUrlPattern));
        this.addElement(WebXmlTag.SERVLET_MAPPING, servletMappingElement, this.getRootElement());
    }

    public final Element getServlet(String theServletName) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        Iterator servletElements = this.getElements(WebXmlTag.SERVLET);
        while (servletElements.hasNext()) {
            Element servletElement = (Element)servletElements.next();
            if (!theServletName.equals(this.getNestedText(servletElement, WebXmlTag.SERVLET_NAME))) continue;
            return servletElement;
        }
        return null;
    }

    public final String getServletInitParam(String theServletName, String theParamName) {
        return this.getInitParam(this.getServlet(theServletName), theParamName);
    }

    public final Iterator getServletInitParamNames(String theServletName) {
        return this.getInitParamNames(this.getServlet(theServletName));
    }

    public final String getServletRunAsRoleName(String theServletName) {
        Element e;
        if (theServletName == null) {
            throw new NullPointerException();
        }
        String roleName = null;
        Element servlet = this.getServlet(theServletName);
        NodeList nodeList = servlet.getElementsByTagName(WebXmlTag.RUN_AS.getTagName());
        if (nodeList != null && (e = (Element)nodeList.item(0)) != null) {
            roleName = this.getNestedText(e, WebXmlTag.ROLE_NAME);
        }
        return roleName;
    }

    public final Iterator getServletMappings(String theServletName) {
        if (theServletName == null) {
            throw new NullPointerException();
        }
        ArrayList<String> servletMappings = new ArrayList<String>();
        Iterator servletMappingElements = this.getElements(WebXmlTag.SERVLET_MAPPING);
        while (servletMappingElements.hasNext()) {
            String urlPattern;
            Element servletMappingElement = (Element)servletMappingElements.next();
            if (!theServletName.equals(this.getNestedText(servletMappingElement, WebXmlTag.SERVLET_NAME)) || (urlPattern = this.getNestedText(servletMappingElement, WebXmlTag.URL_PATTERN)) == null) continue;
            servletMappings.add(urlPattern);
        }
        return servletMappings.iterator();
    }

    public final Iterator getServletNames() {
        ArrayList<String> servletNames = new ArrayList<String>();
        Iterator servletElements = this.getElements(WebXmlTag.SERVLET);
        while (servletElements.hasNext()) {
            Element servletElement = (Element)servletElements.next();
            String servletName = this.getNestedText(servletElement, WebXmlTag.SERVLET_NAME);
            if (servletName == null) continue;
            servletNames.add(servletName);
        }
        return servletNames.iterator();
    }

    public final Iterator getServletNamesForClass(String theClassName) {
        if (theClassName == null) {
            throw new NullPointerException();
        }
        Iterator servletElements = this.getElements(WebXmlTag.SERVLET);
        ArrayList<String> servletNames = new ArrayList<String>();
        while (servletElements.hasNext()) {
            Element servletElement = (Element)servletElements.next();
            if (!theClassName.equals(this.getNestedText(servletElement, WebXmlTag.SERVLET_CLASS))) continue;
            servletNames.add(this.getNestedText(servletElement, WebXmlTag.SERVLET_NAME));
        }
        return servletNames.iterator();
    }

    public final Iterator getServletNamesForJspFile(String theJspFile) {
        if (theJspFile == null) {
            throw new NullPointerException();
        }
        Iterator servletElements = this.getElements(WebXmlTag.SERVLET);
        ArrayList<String> servletNames = new ArrayList<String>();
        while (servletElements.hasNext()) {
            Element servletElement = (Element)servletElements.next();
            if (!theJspFile.equals(this.getNestedText(servletElement, WebXmlTag.JSP_FILE))) continue;
            servletNames.add(this.getNestedText(servletElement, WebXmlTag.SERVLET_NAME));
        }
        return servletNames.iterator();
    }

    public final boolean hasServlet(String theServletName) {
        return this.getServlet(theServletName) != null;
    }

    public final void addSecurityConstraint(String theWebResourceName, String theUrlPattern, List theRoles) {
        if (theWebResourceName == null || theUrlPattern == null || theRoles == null) {
            throw new NullPointerException();
        }
        if (this.hasSecurityConstraint(theUrlPattern)) {
            throw new IllegalStateException("Security constraint for URL pattern " + theUrlPattern + " already defined");
        }
        Element securityConstraintElement = this.getDocument().createElement(WebXmlTag.SECURITY_CONSTRAINT.getTagName());
        Element webResourceCollectionElement = this.getDocument().createElement(WebXmlTag.WEB_RESOURCE_COLLECTION.getTagName());
        webResourceCollectionElement.appendChild(this.createNestedText(WebXmlTag.WEB_RESOURCE_NAME, theWebResourceName));
        webResourceCollectionElement.appendChild(this.createNestedText(WebXmlTag.URL_PATTERN, theUrlPattern));
        securityConstraintElement.appendChild(webResourceCollectionElement);
        Element authConstraintElement = this.getDocument().createElement(WebXmlTag.AUTH_CONSTRAINT.getTagName());
        Iterator i = theRoles.iterator();
        while (i.hasNext()) {
            authConstraintElement.appendChild(this.createNestedText(WebXmlTag.ROLE_NAME, (String)i.next()));
        }
        securityConstraintElement.appendChild(authConstraintElement);
        this.addElement(WebXmlTag.SECURITY_CONSTRAINT, securityConstraintElement, this.getRootElement());
    }

    public final Element getSecurityConstraint(String theUrlPattern) {
        if (theUrlPattern == null) {
            throw new NullPointerException();
        }
        Iterator securityConstraintElements = this.getElements(WebXmlTag.SECURITY_CONSTRAINT);
        while (securityConstraintElements.hasNext()) {
            Element webResourceCollectionElement;
            Element securityConstraintElement = (Element)securityConstraintElements.next();
            Iterator webResourceCollectionElements = this.getNestedElements(securityConstraintElement, WebXmlTag.WEB_RESOURCE_COLLECTION);
            if (!webResourceCollectionElements.hasNext() || !theUrlPattern.equals(this.getNestedText(webResourceCollectionElement = (Element)webResourceCollectionElements.next(), WebXmlTag.URL_PATTERN))) continue;
            return securityConstraintElement;
        }
        return null;
    }

    public final boolean hasSecurityConstraint(String theUrlPattern) {
        return this.getSecurityConstraint(theUrlPattern) != null;
    }

    public final boolean hasLoginConfig() {
        return this.getLoginConfig() != null;
    }

    public final Element getLoginConfig() {
        Iterator loginConfigElements = this.getElements(WebXmlTag.LOGIN_CONFIG);
        if (loginConfigElements.hasNext()) {
            return (Element)loginConfigElements.next();
        }
        return null;
    }

    public final String getLoginConfigAuthMethod() {
        return this.getNestedText(this.getLoginConfig(), WebXmlTag.AUTH_METHOD);
    }

    public final void setLoginConfig(String theAuthMethod, String theRealmName) {
        if (theRealmName == null || theAuthMethod == null) {
            throw new NullPointerException();
        }
        Element loginConfigElement = this.getDocument().createElement(WebXmlTag.LOGIN_CONFIG.getTagName());
        loginConfigElement.appendChild(this.createNestedText(WebXmlTag.AUTH_METHOD, theAuthMethod));
        loginConfigElement.appendChild(this.createNestedText(WebXmlTag.REALM_NAME, theRealmName));
        this.replaceElement(WebXmlTag.LOGIN_CONFIG, loginConfigElement, this.getRootElement());
    }

    public final void addSecurityRole(String theRoleName) {
        if (theRoleName == null) {
            throw new NullPointerException();
        }
        if (this.hasSecurityRole(theRoleName)) {
            throw new IllegalStateException("Security role '" + theRoleName + "' already defined");
        }
        Element securityRoleElement = this.getDocument().createElement(WebXmlTag.SECURITY_ROLE.getTagName());
        securityRoleElement.appendChild(this.createNestedText(WebXmlTag.ROLE_NAME, theRoleName));
        this.addElement(WebXmlTag.SECURITY_ROLE, securityRoleElement, this.getRootElement());
    }

    public final Element getSecurityRole(String theRoleName) {
        if (theRoleName == null) {
            throw new NullPointerException();
        }
        Iterator securityRoleElements = this.getElements(WebXmlTag.SECURITY_ROLE);
        while (securityRoleElements.hasNext()) {
            Element securityRoleElement = (Element)securityRoleElements.next();
            if (!theRoleName.equals(this.getNestedText(securityRoleElement, WebXmlTag.ROLE_NAME))) continue;
            return securityRoleElement;
        }
        return null;
    }

    public final Iterator getSecurityRoleNames() {
        ArrayList<String> securityRoleNames = new ArrayList<String>();
        Iterator securityRoleElements = this.getElements(WebXmlTag.SECURITY_ROLE);
        while (securityRoleElements.hasNext()) {
            Element securityRoleElement = (Element)securityRoleElements.next();
            String securityRoleName = this.getNestedText(securityRoleElement, WebXmlTag.ROLE_NAME);
            if (securityRoleName == null) continue;
            securityRoleNames.add(securityRoleName);
        }
        return securityRoleNames.iterator();
    }

    public final boolean hasSecurityRole(String theRoleName) {
        return this.getSecurityRole(theRoleName) != null;
    }

    public final void addRootElement(AbstractDescriptorTag tag, Element element) {
        super.addElement(tag, element, this.getRootElement());
    }

    public final void replaceRootElement(AbstractDescriptorTag tag, Element element) {
        super.replaceElement(tag, element, this.getRootElement());
    }

    public final void addLocalSessionEjbRef(String name, String local, String localHome, String jndiName) {
        this.addLocalEjbRef(name, "Session", local, localHome, jndiName);
    }

    public final void addLocalEntityEjbRef(String name, String local, String localHome, String jndiName) {
        this.addLocalEjbRef(name, "Entity", local, localHome, jndiName);
    }

    private void addLocalEjbRef(String name, String type, String local, String localHome, String jndiName) {
        Element ejbRefElement = this.getDocument().createElement(WebXmlTag.EJB_LOCAL_REF.getTagName());
        ejbRefElement.setAttribute("id", name.replace('/', '_'));
        ejbRefElement.appendChild(this.createNestedText(WebXmlTag.EJB_REF_NAME, name));
        ejbRefElement.appendChild(this.createNestedText(WebXmlTag.EJB_REF_TYPE, type));
        ejbRefElement.appendChild(this.createNestedText(WebXmlTag.LOCAL_HOME, localHome));
        ejbRefElement.appendChild(this.createNestedText(WebXmlTag.LOCAL, local));
        this.addRootElement(WebXmlTag.EJB_LOCAL_REF, ejbRefElement);
        Iterator i = this.vendorDescriptors.iterator();
        while (i.hasNext()) {
            VendorWebAppDescriptor descr = (VendorWebAppDescriptor)i.next();
            descr.addEjbReference(name, jndiName);
        }
    }

    private void addInitParam(Element theElement, String theParamName, String theParamValue) {
        Element initParamElement = this.getDocument().createElement(WebXmlTag.INIT_PARAM.getTagName());
        initParamElement.appendChild(this.createNestedText(WebXmlTag.PARAM_NAME, theParamName));
        initParamElement.appendChild(this.createNestedText(WebXmlTag.PARAM_VALUE, theParamValue));
        Iterator loadOnStartupElements = this.getNestedElements(theElement, WebXmlTag.LOAD_ON_STARTUP);
        if (loadOnStartupElements.hasNext()) {
            theElement.insertBefore(initParamElement, (Element)loadOnStartupElements.next());
        } else {
            theElement.appendChild(initParamElement);
        }
    }

    private String getInitParam(Element theElement, String theParamName) {
        if (theElement != null) {
            NodeList initParamElements = theElement.getElementsByTagName(WebXmlTag.INIT_PARAM.getTagName());
            for (int i = 0; i < initParamElements.getLength(); ++i) {
                Element initParamElement = (Element)initParamElements.item(i);
                String paramName = this.getNestedText(initParamElement, WebXmlTag.PARAM_NAME);
                if (!theParamName.equals(paramName)) continue;
                return this.getNestedText(initParamElement, WebXmlTag.PARAM_VALUE);
            }
        }
        return null;
    }

    private Iterator getInitParamNames(Element theElement) {
        ArrayList<String> initParamNames = new ArrayList<String>();
        if (theElement != null) {
            NodeList initParamElements = theElement.getElementsByTagName(WebXmlTag.INIT_PARAM.getTagName());
            for (int i = 0; i < initParamElements.getLength(); ++i) {
                Element initParamElement = (Element)initParamElements.item(i);
                String paramName = this.getNestedText(initParamElement, WebXmlTag.PARAM_NAME);
                if (paramName == null) continue;
                initParamNames.add(paramName);
            }
        }
        return initParamNames.iterator();
    }
}

