/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.context;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.jboss.jsfunit.context.JSFUnitExternalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFUnitHttpServletRequest
implements HttpServletRequest {
    private JSFUnitExternalContext extCtx;
    private boolean isServlet24OrGreater = false;
    private String localName = "";
    private String localAddr = "";
    private int localPort = 0;
    private int remotePort = 0;
    private String queryString;
    private String protocol;
    private String pathTranslated;
    private String method;
    private Map parameterMap;
    private int contentLength;
    private Cookie[] cookies;
    private String remoteAddr;
    private String remoteHost;
    private String requestURI;
    private StringBuffer requestURL;
    private String requestedSessionId;
    private String scheme;
    private String serverName;
    private int serverPort;
    private boolean isRequestedSessionIdFromCookie;
    private boolean isRequestedSessionIdFromURL;
    private boolean isRequestedSessionIdValid;
    private boolean isSecure;
    private Locale locale;
    private String authType;
    private String characterEncoding;
    private String contentType;
    private String contextPath;

    public JSFUnitHttpServletRequest(JSFUnitExternalContext extCtx, HttpServletRequest request) {
        this.extCtx = extCtx;
        this.isServlet24OrGreater = this.isServlet24OrGreater();
        this.cacheServlet24RequestValues(request);
        this.queryString = request.getQueryString();
        this.protocol = request.getProtocol();
        this.pathTranslated = request.getPathTranslated();
        this.method = request.getMethod();
        this.parameterMap = request.getParameterMap();
        this.contentLength = request.getContentLength();
        this.cookies = request.getCookies();
        this.remoteAddr = request.getRemoteAddr();
        this.remoteHost = request.getRemoteHost();
        this.requestURI = request.getRequestURI();
        this.requestURL = new StringBuffer(request.getRequestURL());
        this.requestedSessionId = request.getRequestedSessionId();
        this.scheme = request.getScheme();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        this.isRequestedSessionIdFromCookie = request.isRequestedSessionIdFromCookie();
        this.isRequestedSessionIdFromURL = request.isRequestedSessionIdFromURL();
        this.isRequestedSessionIdValid = request.isRequestedSessionIdValid();
        this.isSecure = request.isSecure();
        this.locale = request.getLocale();
        this.authType = request.getAuthType();
        this.characterEncoding = request.getCharacterEncoding();
        this.contentType = request.getContentType();
        this.contextPath = request.getContextPath();
    }

    private boolean isServlet24OrGreater() {
        ServletContext servletContext = (ServletContext)this.extCtx.getContext();
        int major = servletContext.getMajorVersion();
        int minor = servletContext.getMinorVersion();
        return major > 2 || major == 2 && minor > 3;
    }

    private void cacheServlet24RequestValues(HttpServletRequest request) {
        if (!this.isServlet24OrGreater) {
            return;
        }
        this.localName = request.getLocalName();
        this.localAddr = request.getLocalAddr();
        this.localPort = request.getLocalPort();
        this.remotePort = request.getRemotePort();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getPathInfo() {
        return this.extCtx.getRequestPathInfo();
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.extCtx.getRequestParameterMap().keySet());
    }

    public Map getParameterMap() {
        return this.parameterMap;
    }

    public String getMethod() {
        return this.method;
    }

    public Enumeration getLocales() {
        return this.makeEnumeration(this.extCtx.getRequestLocales());
    }

    private Enumeration makeEnumeration(Iterator iterator) {
        HashSet mySet = new HashSet();
        while (iterator.hasNext()) {
            mySet.add(iterator.next());
        }
        return Collections.enumeration(mySet);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.extCtx.getRequestMap().keySet());
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.extCtx.getRequestHeaderMap().keySet());
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteUser() {
        return this.extCtx.getRemoteUser();
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getServletPath() {
        return this.extCtx.getRequestServletPath();
    }

    public HttpSession getSession() {
        return (HttpSession)this.extCtx.getSession(true);
    }

    public Principal getUserPrincipal() {
        return this.extCtx.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.isRequestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.isRequestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL;
    }

    public boolean isRequestedSessionIdValid() {
        return this.isRequestedSessionIdValid;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public HttpSession getSession(boolean create) {
        return (HttpSession)this.extCtx.getSession(create);
    }

    public void setAttribute(String attribute, Object value) {
        this.extCtx.getRequestMap().put(attribute, value);
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
    }

    public String[] getParameterValues(String name) {
        return (String[])this.extCtx.getRequestParameterValuesMap().get(name);
    }

    public String getParameter(String name) {
        return (String)this.extCtx.getRequestParameterMap().get(name);
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    public Object getAttribute(String name) {
        return this.extCtx.getRequestMap().get(name);
    }

    public long getDateHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1L;
        }
        return Date.parse(header);
    }

    public String getHeader(String name) {
        return (String)this.extCtx.getRequestHeaderMap().get(name);
    }

    public Enumeration getHeaders(String name) {
        String[] headers = (String[])this.extCtx.getRequestHeaderValuesMap().get(name);
        if (headers == null) {
            headers = new String[]{};
        }
        return Collections.enumeration(Arrays.asList(headers));
    }

    public String getRealPath(String string) {
        throw new UnsupportedOperationException();
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String name) {
        return this.extCtx.isUserInRole(name);
    }

    public void removeAttribute(String name) {
        this.extCtx.getRequestMap().remove(name);
    }

    public int getLocalPort() {
        if (!this.isServlet24OrGreater) {
            throw new UnsupportedOperationException();
        }
        return this.localPort;
    }

    public int getRemotePort() {
        if (!this.isServlet24OrGreater) {
            throw new UnsupportedOperationException();
        }
        return this.remotePort;
    }

    public String getLocalName() {
        if (!this.isServlet24OrGreater) {
            throw new UnsupportedOperationException();
        }
        return this.localName;
    }

    public String getLocalAddr() {
        if (!this.isServlet24OrGreater) {
            throw new UnsupportedOperationException();
        }
        return this.localAddr;
    }

    public Part getPart(String part) {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public ServletContext getServletContext() {
        throw new UnsupportedOperationException();
    }
}

