/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.init;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import org.apache.cactus.ServletTestCase;
import org.jboss.jsfunit.init.AllJSFUnitTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlesTypes(value={ServletTestCase.class})
public class JSFUnitSCI
implements ServletContainerInitializer {
    public static final String APP_SCOPE_KEY = "JSFUnitTests";
    private List<String> jsfunitTests;

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        ctx.setAttribute(APP_SCOPE_KEY, (Object)this);
        TreeSet<String> sortedByClassname = new TreeSet<String>();
        HashSet jsfunitClasses = new HashSet();
        for (Class<?> clazz : classes) {
            String className = clazz.getName();
            if (className.startsWith("org.apache.cactus") || className.startsWith("org.jboss.jsfunit.init")) continue;
            sortedByClassname.add(className);
            jsfunitClasses.add(clazz);
        }
        this.jsfunitTests = new ArrayList<String>(sortedByClassname);
        AllJSFUnitTests.setAllTests(jsfunitClasses);
    }

    public List<String> getTests() {
        return this.jsfunitTests;
    }
}

