/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.junitdiff;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.qa.junitdiff.ex.JUnitDiffException;
import org.jboss.qa.junitdiff.model.Failure;
import org.jboss.qa.junitdiff.model.TestInfo;
import org.jboss.qa.junitdiff.model.TestRunResultsList;
import org.jboss.qa.junitdiff.model.TestSuite;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileParsing {
    private static final Logger log = LoggerFactory.getLogger(FileParsing.class);
    private static final int MAX_LIST_FILE_SIZE_KB = 512;

    public static List<TestSuite> getSeparatedResultsLists(List<File> reportFiles) throws JUnitDiffException {
        LinkedList<TestSuite> reportsLists = new LinkedList<TestSuite>();
        ArrayList<JUnitDiffException> errors = new ArrayList<JUnitDiffException>();
        for (File file : reportFiles) {
            if (!file.isFile()) {
                log.warn("  Not a regular file: " + file.getPath());
                continue;
            }
            if (file.length() == 0L) {
                log.warn("  File is empty: " + file.getPath());
                continue;
            }
            try {
                TestSuite ts = FileParsing.parseFile(file);
                reportsLists.add(ts);
            }
            catch (JUnitDiffException ex) {
                String msg = "  Error processing '" + file.getPath() + "': " + ex.getMessage();
                log.error(msg);
                errors.add(new JUnitDiffException(msg, ex));
            }
        }
        if (!errors.isEmpty()) {
            throw new JUnitDiffException("Errors (" + errors.size() + ") when processing files.", errors);
        }
        return reportsLists;
    }

    private static TestSuite parseFile(File file) throws JUnitDiffException {
        boolean isXml = file.getName().endsWith(".xml");
        try {
            TestSuite ts = FileParsing.tryParsingAsXml(file);
            return ts;
        }
        catch (JDOMException ex) {
            throw new JUnitDiffException("  Failed parsing '" + file.getPath() + "' as XML JUnit test report: " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new JUnitDiffException("  Error reading from file '" + file.getPath() + "': " + ex.getMessage());
        }
    }

    private static TestRunResultsList parseAsListOfFiles(File file) throws JUnitDiffException {
        List<String> readLines;
        if (file.length() > 524288L) {
            log.warn("  File is too big (" + file.length() / 1024L + " kb) : " + file.getPath());
        }
        try {
            readLines = FileUtils.readLines(file);
        }
        catch (IOException ex) {
            throw new JUnitDiffException("  Error reading from file '" + file.getPath() + "': " + ex.getMessage());
        }
        ArrayList<TestRunResultsList> trls = new ArrayList<TestRunResultsList>();
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (String line : readLines) {
            String msg;
            line = line.trim();
            try {
                TestSuite ts = FileParsing.tryParsingAsXml(new File(line));
                trls.add(ts.getTestRunResultsList());
            }
            catch (JDOMException ex) {
                msg = "  Error parsing '" + file.getPath() + "': " + ex.getMessage();
                log.error(msg);
                errors.add(ex);
            }
            catch (IOException ex) {
                msg = "  Error reading from file '" + file.getPath() + "': " + ex.getMessage();
                log.error(msg);
                errors.add(new IOException(msg));
            }
        }
        if (!errors.isEmpty()) {
            throw new JUnitDiffException("  Errors (" + errors.size() + ") occured when parsing the list of files", errors);
        }
        TestRunResultsList concatenatedResults = TestRunResultsList.fromList(trls);
        return concatenatedResults;
    }

    private static TestSuite tryParsingAsXml(FileInputStream is) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(is);
        return FileParsing.parseJUnitXmlReport(doc);
    }

    private static TestSuite tryParsingAsXml(File file) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(file);
        TestSuite parseJUnitXmlReport = FileParsing.parseJUnitXmlReport(doc);
        parseJUnitXmlReport.setOrigin(file.getPath());
        return parseJUnitXmlReport;
    }

    private static TestSuite parseJUnitXmlReport(Document doc) throws JDOMException {
        XPath xPath = XPath.newInstance("/testsuite/testcase");
        List testcaseElements = xPath.selectNodes(doc);
        TestRunResultsList resultsList = new TestRunResultsList();
        for (Element elm : testcaseElements) {
            Failure fail;
            String trace;
            String type;
            String message;
            String time = elm.getAttributeValue("time");
            String name = elm.getAttributeValue("name");
            String classname = elm.getAttributeValue("classname");
            TestInfo info = new TestInfo(classname, name, TestInfo.Result.OK, time);
            Element child = elm.getChild("failure");
            if (null != child) {
                message = child.getAttributeValue("message");
                type = child.getAttributeValue("type");
                trace = child.getTextNormalize();
                trace = StringUtils.substringAfter(trace, "\n");
                fail = new Failure(message, type, trace);
                info.setResult(TestInfo.Result.FAIL);
                info.setFailure(fail);
            }
            if (null != (child = elm.getChild("error"))) {
                message = child.getAttributeValue("message");
                type = child.getAttributeValue("type");
                trace = child.getTextNormalize();
                trace = StringUtils.substringAfter(trace, "\n");
                fail = new Failure(message, type, trace);
                info.setResult(TestInfo.Result.ERROR);
                info.setFailure(fail);
            }
            resultsList.add(info);
        }
        String systemOut = (String)XPath.selectSingleNode(doc, "string(/testsuite/system-out)");
        String systemErr = (String)XPath.selectSingleNode(doc, "string(/testsuite/system-err)");
        String tsName = (String)XPath.selectSingleNode(doc, "string(/testsuite/@name)");
        TestSuite testSuite = new TestSuite(tsName, resultsList, systemOut, systemErr);
        return testSuite;
    }
}

