/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.junitdiff;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputPreparation {
    private static final Logger log = LoggerFactory.getLogger(InputPreparation.class);
    private static final int BUFFER_SIZE = 2048;

    static List<File> preprocessPaths(List<File> reportFiles) {
        LinkedList<File> expandedPaths = new LinkedList<File>();
        for (File path : reportFiles) {
            if (path.isFile()) {
                if (path.getName().endsWith(".xml")) {
                    expandedPaths.add(path);
                } else {
                    expandedPaths.addAll(InputPreparation.readListOfPaths(path));
                }
            }
            if (!path.isDirectory()) continue;
            expandedPaths.addAll(InputPreparation.scanDirForJUnitReports(path));
        }
        return expandedPaths;
    }

    static void handleURLs(String[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (path == null || !path.startsWith("http://")) continue;
            try {
                File resultDir;
                if (path.endsWith(".zip")) {
                    resultDir = InputPreparation.downloadZipAndExtractToTempDir(path);
                } else if (path.endsWith(".xml")) {
                    resultDir = InputPreparation.downloadUrlToTempFile(path);
                } else {
                    log.warn("  URL is not .zip nor .xml - skipping: " + path);
                    continue;
                }
                paths[i] = resultDir.getPath();
                continue;
            }
            catch (IOException ex) {
                log.warn("  Error when processing URL " + path + ": " + ex.getMessage(), ex);
            }
        }
    }

    private static File downloadZipAndExtractToTempDir(String urlStr) throws MalformedURLException, IOException {
        File tmpFile = InputPreparation.downloadUrlToTempFile(urlStr);
        File dirWithZipContent = InputPreparation.unzipFileToTempDir(tmpFile);
        tmpFile.delete();
        return dirWithZipContent;
    }

    private static File downloadUrlToTempFile(String urlStr) throws MalformedURLException, IOException {
        URL url = new URL(urlStr);
        String path = url.getPath();
        path = StringUtils.strip(path, "\\/");
        path = path.replace('*', '-');
        path = path.replace('?', '-');
        File destZipFile = new File(path);
        destZipFile.getParentFile().mkdirs();
        ReadableByteChannel rbc = Channels.newChannel(url.openStream());
        FileOutputStream fos = new FileOutputStream(destZipFile);
        fos.getChannel().transferFrom(rbc, 0L, 0x1000000L);
        rbc.close();
        fos.close();
        return destZipFile;
    }

    private static List<File> readListOfPaths(File path) {
        try {
            List<String> lines = FileUtils.readLines(path);
            ArrayList<File> paths = new ArrayList<File>(lines.size());
            for (String line : lines) {
                File f = new File(line);
                if (!f.exists()) {
                    log.warn("  Does not exist: " + f.getPath());
                    continue;
                }
                if (!f.isFile()) {
                    log.warn("  Not a regular file: " + f.getPath());
                    continue;
                }
                paths.add(f);
            }
            return paths;
        }
        catch (IOException ex) {
            log.warn("Error reading " + path.getPath() + " : " + ex.getMessage());
            return Collections.EMPTY_LIST;
        }
    }

    private static List<File> scanDirForJUnitReports(final File path) {
        IOFileFilter filter = FileFilterUtils.or(FileFilterUtils.directoryFileFilter(), FileFilterUtils.and(FileFilterUtils.notFileFilter(FileFilterUtils.or(FileFilterUtils.suffixFileFilter(".jar", IOCase.INSENSITIVE), FileFilterUtils.suffixFileFilter(".html", IOCase.INSENSITIVE), FileFilterUtils.suffixFileFilter(".zip", IOCase.INSENSITIVE), FileFilterUtils.suffixFileFilter(".txt", IOCase.INSENSITIVE), FileFilterUtils.suffixFileFilter(".log", IOCase.INSENSITIVE), FileFilterUtils.suffixFileFilter(".class", IOCase.INSENSITIVE), FileFilterUtils.suffixFileFilter(".java", IOCase.INSENSITIVE), FileFilterUtils.suffixFileFilter(".", IOCase.INSENSITIVE))), FileFilterUtils.or(FileFilterUtils.suffixFileFilter(".xml"), FileFilterUtils.prefixFileFilter("TEST"), FileFilterUtils.magicNumberFileFilter("<?xml"))));
        IOFileFilter rigidFilter = FileFilterUtils.or(FileFilterUtils.directoryFileFilter(), FileFilterUtils.and(FileFilterUtils.suffixFileFilter(".xml"), FileFilterUtils.prefixFileFilter("TEST")));
        try {
            LinkedList<File> resultList = new LinkedList<File>();
            new DirectoryWalker((FileFilter)rigidFilter, -1){

                protected void handleFile(File file, int depth, Collection results) throws IOException {
                    results.add(file);
                }

                protected boolean handleDirectory(File directory, int depth, Collection results) throws IOException {
                    return true;
                }

                public void doWalk(LinkedList list) throws IOException {
                    this.walk(path, list);
                }
            }.doWalk(resultList);
            return resultList;
        }
        catch (IOException ex) {
            return Collections.EMPTY_LIST;
        }
    }

    private static File unzipFileToTempDir(File file) throws IOException {
        String path = file.getPath();
        path = path.endsWith(".zip") ? StringUtils.removeEndIgnoreCase(path, ".zip") : path + "-";
        File tmpDir = new File(path);
        tmpDir.mkdir();
        tmpDir.deleteOnExit();
        byte[] data = new byte[2048];
        try {
            ZipFile zipfile = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            while (e.hasMoreElements()) {
                int count;
                ZipEntry entry = e.nextElement();
                if (entry.isDirectory() || entry.getName().contains("..")) continue;
                log.trace("  Extracting: " + entry);
                BufferedInputStream is = new BufferedInputStream(zipfile.getInputStream(entry));
                File destFile = new File(tmpDir, entry.getName());
                destFile.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                while ((count = is.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                is.close();
            }
        }
        catch (Exception ex) {
            log.error(" Error when unzipping " + file.getPath() + ": " + ex.getMessage());
            tmpDir.delete();
        }
        return tmpDir;
    }
}

