/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.junitdiff;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jboss.qa.junitdiff.FileParsing;
import org.jboss.qa.junitdiff.InputPreparation;
import org.jboss.qa.junitdiff.ex.JUnitDiffException;
import org.jboss.qa.junitdiff.export.XmlExporter;
import org.jboss.qa.junitdiff.model.AggregatedData;
import org.jboss.qa.junitdiff.model.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitDiffApp {
    private static final Logger log = LoggerFactory.getLogger(JUnitDiffApp.class);
    private static final String DEFAULT_OUT_FILE = "AGGREGATED_TEST.xml";

    public static void main(String[] args) {
        log.debug("Starting JUnitDiff - multiple test runs results comparison.");
        if (args.length == 0) {
            System.out.println("  Aggregates multiple JUnit XML reports into one comprehensible page.");
            System.out.println("  Usage:");
            System.out.println("    java -jar JUnitDiff.jar -o ('-' | outputPath) ( dir | TEST-foo.xml | list-of-paths.txt | http://host/reports.zip )+");
            System.out.println("");
            System.out.println("    -o      Output file. '-' dumps the result to the stdout. Logging output always goes to the stderr.");
            System.out.println("");
            System.out.println("  Examples:");
            System.out.println("    java -jar JUnitDiff.jar -o - > aggregated-test-report.html");
            System.out.println("    java -jar JUnitDiff.jar -xml -o aggregated-test-report.xml");
            System.exit(1);
        }
        String outFile = null;
        boolean htmlOutput = true;
        boolean stdOut = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-xml".equals(args[i])) {
                htmlOutput = false;
                args[i] = null;
                continue;
            }
            if (!"-o".equals(args[i])) continue;
            args[i] = null;
            if (args.length <= i) continue;
            outFile = args[i + 1];
            args[i + 1] = null;
            ++i;
        }
        if ("-".equals(outFile)) {
            stdOut = true;
            outFile = null;
        }
        if (null == outFile) {
            outFile = DEFAULT_OUT_FILE + (htmlOutput ? ".html" : "");
        }
        new JUnitDiffApp().runApp(args, outFile, htmlOutput, stdOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runApp(String[] paths, String outFile, boolean htmlOutput, boolean toStdOut) {
        ArrayList<File> reportFiles = new ArrayList<File>(paths.length);
        InputPreparation.handleURLs(paths);
        for (String path : paths) {
            if (path == null) continue;
            File reportFile = new File(path);
            if (!reportFile.exists()) {
                throw new IllegalArgumentException("  File " + reportFile.getPath() + " does not exist.");
            }
            reportFiles.add(reportFile);
        }
        AggregatedData aggregatedData = new AggregatedData();
        for (File file : reportFiles) {
            String groupName = file.getPath();
            List<File> inList = Collections.singletonList(file);
            List<File> filesToProcess = InputPreparation.preprocessPaths(inList);
            if (filesToProcess.isEmpty()) {
                log.warn("No report files to process from source '" + groupName + "'.");
                continue;
            }
            List<TestSuite> testSuites = JUnitDiffApp.processGroup(groupName, filesToProcess);
            if (testSuites.isEmpty()) {
                log.warn("No testsuites to process from source '" + groupName + "'.");
                continue;
            }
            log.info("Aggregating test results - group: " + groupName + " - " + testSuites.size() + " test suites.");
            try {
                aggregatedData.mergeTestSuites(testSuites, groupName);
            }
            catch (Exception ex) {
                log.error("Error when aggregating: " + ex.getMessage(), ex);
                System.exit(3);
            }
        }
        if (aggregatedData.getTestSuites().size() == 0) {
            log.error("No results to process.");
            System.exit(4);
        }
        log.info("Exporting to " + outFile);
        if (!htmlOutput) {
            try {
                XmlExporter.exportToXML(aggregatedData, new File(outFile));
            }
            catch (FileNotFoundException ex) {
                log.error("Can't write to file '" + outFile + "': " + ex.getMessage());
                System.exit(5);
            }
        } else {
            try {
                XmlExporter.exportToHtmlFile(aggregatedData, new File(outFile));
            }
            catch (JUnitDiffException ex) {
                log.error(ex.getMessage(), ex);
                System.exit(6);
            }
        }
        if (toStdOut) {
            log.debug("Output goes to stdout.");
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(outFile);
                IOUtils.copy((Reader)fileReader, (OutputStream)System.out);
            }
            catch (FileNotFoundException ex) {
                log.error(ex.toString());
            }
            catch (IOException ex) {
                log.error(ex.toString());
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException ex) {
                        log.error(ex.toString());
                    }
                }
            }
        }
    }

    private static List<TestSuite> processGroup(String groupName, List<File> reportFiles) {
        List<TestSuite> testSuites;
        log.info("Parsing test reports group '" + groupName + "': " + reportFiles.size() + " files.");
        try {
            testSuites = FileParsing.getSeparatedResultsLists(reportFiles);
        }
        catch (JUnitDiffException ex) {
            log.error(ex.getMessage(), ex);
            return Collections.emptyList();
        }
        for (TestSuite testSuite : testSuites) {
            testSuite.setGroup(groupName);
        }
        return testSuites;
    }
}

