/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.junitdiff;

import java.util.List;
import org.jboss.qa.junitdiff.model.AggregatedTestInfo;
import org.jboss.qa.junitdiff.model.AggregatedTestResults;
import org.jboss.qa.junitdiff.model.TestInfo;
import org.jboss.qa.junitdiff.model.TestRunResultsList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Processing {
    private static final Logger log = LoggerFactory.getLogger(Processing.class);

    private AggregatedTestResults xaggregateResultsLists(List<TestRunResultsList> reportsLists) {
        AggregatedTestResults agg = new AggregatedTestResults();
        return this.aggregateResultsLists(reportsLists, agg);
    }

    private AggregatedTestResults aggregateResultsLists(List<TestRunResultsList> reportsLists, AggregatedTestResults agg) {
        for (TestRunResultsList testResultsList : reportsLists) {
            log.debug("  Aggregating " + testResultsList.toString() + "...");
            for (TestInfo curTest : testResultsList.getTestResults()) {
                String fullName = curTest.getFullName();
                AggregatedTestInfo aggTest = agg.findTestByFullName(fullName);
                if (aggTest == null) {
                    aggTest = new AggregatedTestInfo(curTest);
                    agg.add(aggTest);
                }
                aggTest.add(curTest);
            }
        }
        return agg;
    }
}

