/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.junitdiff.export;

import cz.dynawest.xslt.XsltTransformer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.jboss.qa.junitdiff.JUnitDiffApp;
import org.jboss.qa.junitdiff.ex.JUnitDiffException;
import org.jboss.qa.junitdiff.model.AggregatedData;
import org.jboss.qa.junitdiff.model.AggregatedTestInfo;
import org.jboss.qa.junitdiff.model.AggregatedTestResults;
import org.jboss.qa.junitdiff.model.TestInfo;
import org.jboss.qa.junitdiff.model.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlExporter {
    private static final Logger log = LoggerFactory.getLogger(JUnitDiffApp.class);
    private static final String XSL_TEMPLATE_PATH = "/JUnitDiff-to-HTML.xsl";

    public static void exportToHtmlFile(AggregatedData aggData, File fout) throws JUnitDiffException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XmlExporter.exportToXML(aggData, new PrintStream(baos));
        try {
            ReaderInputStream ris = new ReaderInputStream((Reader)new StringReader(baos.toString("utf8")), "utf8");
            InputStream xslTemplate = XmlExporter.class.getResourceAsStream(XSL_TEMPLATE_PATH);
            XsltTransformer.transform(ris, xslTemplate, fout);
        }
        catch (TransformerException ex) {
            throw new JUnitDiffException("Error when creating HTML file: " + ex.getMessage(), ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void exportToXML(AggregatedData aggData, File fout) throws FileNotFoundException {
        XmlExporter.exportToXML(aggData, new PrintStream(fout));
    }

    public static void exportToXML(AggregatedData aggData, PrintStream out) {
        out.println("<aggregate>");
        AggregatedTestResults atr = aggData.getAggregatedTestResults();
        out.println("\t<groups>");
        List<String> groups = atr.getGroups();
        List<String> groupDiffNames = atr.getGroupNamesDifferingParts();
        for (int i = 0; i < groups.size(); ++i) {
            String groupName = groups.get(i);
            String groupNameDifferingPart = groupDiffNames.get(i);
            out.append("\t\t<group name=\"").append(XmlExporter.x(groupNameDifferingPart)).append("\" path=\"").append(XmlExporter.x(groupName)).append("\"/>\n");
        }
        out.println("\t</groups>\n");
        for (AggregatedTestInfo ati : atr.getTestInfos()) {
            out.append("\t<testcase classname=\"").append(XmlExporter.x(ati.getClassName())).append("\" name=\"").append(XmlExporter.x(ati.getName())).append("\">\n");
            for (TestInfo ti : ati.getTestInfos()) {
                out.append("\t\t<testrun result=\"").append(XmlExporter.x(ti.getResult().name())).append("\" time=\"").append(XmlExporter.x(ti.getTime())).append("\" group=\"").append(XmlExporter.x(ti.getGroup())).append("\">\n");
                if (null != ti.getFailure()) {
                    out.append("\t\t\t<failure message=\"").append(XmlExporter.x(ti.getFailure().getMessage())).append("\" type=\"").append(XmlExporter.x(ti.getFailure().getType())).append("\">\n");
                    out.print(XmlExporter.x(ti.getFailure().getTrace()));
                    out.println("</failure>");
                }
                out.println("\t\t</testrun>");
            }
            out.println("\t</testcase>");
        }
        out.println("\t<testsuites>");
        for (TestSuite ts : aggData.getTestSuites()) {
            out.append("\t\t<testsuite group=\"").append(XmlExporter.x(ts.getGroup())).append("\" name=\"").append(XmlExporter.x(ts.getClassName())).append("\" origin=\"").append(XmlExporter.x(ts.getOrigin())).append("\">\n");
            out.append("\t\t<system-out><![CDATA[").append(ts.getStdOut()).append("]]></system-out>\n");
            out.append("\t\t<system-err><![CDATA[").append(ts.getStdErr()).append("]]></system-err>\n");
            out.println("\t\t</testsuite>");
        }
        out.println("\t</testsuites>\n");
        out.println("</aggregate>");
    }

    private static String x(String s) {
        return StringEscapeUtils.escapeXml(s);
    }
}

