/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.junitdiff.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.qa.junitdiff.model.TestInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedTestInfo {
    private String className;
    private String name;
    private List<TestInfo> testInfos = new ArrayList<TestInfo>();

    public AggregatedTestInfo(String className, String name) {
        this.name = name;
        this.className = className;
    }

    public AggregatedTestInfo(String name, List<TestInfo> testInfos) {
        this.name = name;
        this.testInfos = testInfos;
    }

    public AggregatedTestInfo(TestInfo test) {
        this.name = test.getName();
        this.className = test.getClassname();
    }

    public int size() {
        return this.testInfos.size();
    }

    public boolean isEmpty() {
        return this.testInfos.isEmpty();
    }

    public TestInfo get(int index) {
        return this.testInfos.get(index);
    }

    public boolean addAll(Collection<? extends TestInfo> c) {
        return this.testInfos.addAll(c);
    }

    public boolean add(TestInfo e) {
        return this.testInfos.add(e);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<TestInfo> getTestInfos() {
        return Collections.unmodifiableList(this.testInfos);
    }

    public String getFullName() {
        return this.getClassName() + "." + this.getName();
    }
}

