/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.junitdiff.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.jboss.qa.junitdiff.model.AggregatedTestInfo;
import org.jboss.qa.junitdiff.model.TestInfo;
import org.jboss.qa.junitdiff.model.TestRunResultsList;
import org.jboss.qa.junitdiff.model.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedTestResults {
    private static final Logger log = LoggerFactory.getLogger(AggregatedTestResults.class);
    private List<AggregatedTestInfo> testInfos = new ArrayList<AggregatedTestInfo>();
    private Map<String, AggregatedTestInfo> byFullTestName = new TreeMap<String, AggregatedTestInfo>();
    private List<String> groups = new ArrayList<String>();
    private int nextGroupNum = 1;

    public AggregatedTestInfo findTestByFullName(String fullName) {
        return this.byFullTestName.get(fullName);
    }

    public List<TestRunResultsList> mergeTestSuites(List<TestSuite> testSuites, String groupName) {
        ArrayList<TestRunResultsList> reportsLists = new ArrayList<TestRunResultsList>(testSuites.size());
        for (TestSuite testSuite : testSuites) {
            reportsLists.add(testSuite.getTestRunResultsList());
        }
        this.merge(reportsLists, groupName);
        return reportsLists;
    }

    public void merge(List<TestRunResultsList> reportsLists) {
        this.merge(reportsLists, this.generateGroupName());
    }

    public void merge(List<TestRunResultsList> reportsLists, String groupName) {
        boolean trace = log.isTraceEnabled();
        this.groups.add(groupName);
        for (TestRunResultsList testResultsList : reportsLists) {
            if (trace) {
                log.trace("  Aggregating {}", testResultsList);
            }
            for (TestInfo curTest : testResultsList.getTestResults()) {
                String fullName = curTest.getFullName();
                AggregatedTestInfo aggTest = this.findTestByFullName(fullName);
                if (aggTest == null) {
                    aggTest = new AggregatedTestInfo(curTest);
                    this.add(aggTest);
                }
                curTest.setGroup(groupName);
                aggTest.add(curTest);
            }
        }
    }

    private String generateGroupName() {
        return "Group" + this.nextGroupNum++;
    }

    public int size() {
        return this.testInfos.size();
    }

    public boolean isEmpty() {
        return this.testInfos.isEmpty();
    }

    public AggregatedTestInfo get(int index) {
        return this.testInfos.get(index);
    }

    public boolean add(AggregatedTestInfo e) {
        this.byFullTestName.put(e.getFullName(), e);
        return this.testInfos.add(e);
    }

    public boolean addAll(Collection<? extends AggregatedTestInfo> atis) {
        for (AggregatedTestInfo aggregatedTestInfo : atis) {
            this.byFullTestName.put(aggregatedTestInfo.getFullName(), aggregatedTestInfo);
        }
        return this.testInfos.addAll(atis);
    }

    public boolean containsByName(String fullName) {
        return this.byFullTestName.containsKey(fullName);
    }

    public List<AggregatedTestInfo> getTestInfos() {
        return Collections.unmodifiableList(this.testInfos);
    }

    public List<String> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public List<String> getGroupNamesDifferingParts() {
        String commonPrefix = StringUtils.getCommonPrefix(this.groups.toArray(new String[this.groups.size()]));
        if (commonPrefix.length() == 0) {
            return Collections.unmodifiableList(this.groups);
        }
        ArrayList<String> shortNames = new ArrayList<String>(this.groups.size());
        ArrayList<String> revertedShortNames = new ArrayList<String>(this.groups.size());
        for (String string : this.groups) {
            String differingPart = string.substring(commonPrefix.length());
            shortNames.add(differingPart);
            revertedShortNames.add(StringUtils.reverse(differingPart));
        }
        String commonSuffix = StringUtils.getCommonPrefix(revertedShortNames.toArray(new String[revertedShortNames.size()]));
        if (commonSuffix.length() == 0) {
            return Collections.unmodifiableList(shortNames);
        }
        shortNames.clear();
        for (String revertedName : revertedShortNames) {
            shortNames.add(StringUtils.reverse(revertedName.substring(commonSuffix.length())));
        }
        return Collections.unmodifiableList(shortNames);
    }
}

