/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.junitdiff.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.qa.junitdiff.model.TestInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunResultsList
implements Serializable {
    private String origin;
    private String group;
    private List<TestInfo> testResults = new ArrayList<TestInfo>();

    public TestRunResultsList(String origin) {
        this.origin = origin;
    }

    public TestRunResultsList() {
    }

    public TestRunResultsList(List<TestInfo> testResults) {
        this.testResults = testResults;
    }

    public boolean isEmpty() {
        return this.testResults.isEmpty();
    }

    public TestInfo get(int index) {
        return this.testResults.get(index);
    }

    public boolean contains(Object o) {
        return this.testResults.contains(o);
    }

    public boolean addAll(Collection<? extends TestInfo> c) {
        return this.testResults.addAll(c);
    }

    public boolean add(TestInfo e) {
        return this.testResults.add(e);
    }

    public static TestRunResultsList fromList(List<TestRunResultsList> trls) {
        int totalTests = 0;
        for (TestRunResultsList trl : trls) {
            totalTests += trl.testResults.size();
        }
        ArrayList<TestInfo> results = new ArrayList<TestInfo>(totalTests);
        for (TestRunResultsList trl : trls) {
            results.addAll(trl.getTestResults());
        }
        return new TestRunResultsList(results);
    }

    public String toString() {
        return "TestResultsList{ [" + this.testResults.size() + "], origin: " + this.origin + '}';
    }

    public List<TestInfo> getTestResults() {
        return this.testResults;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

