/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.model;

import com.sun.codemodel.internal.JAssignmentTarget;
import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JStatement;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.processor.intf.model.MessageInterface;
import org.jboss.logging.processor.intf.model.MessageMethod;
import org.jboss.logging.processor.intf.model.Parameter;
import org.jboss.logging.processor.intf.model.ThrowableType;
import org.jboss.logging.processor.model.ClassModel;
import org.jboss.logging.processor.model.ClassModelHelper;

abstract class ImplementationClassModel
extends ClassModel {
    ImplementationClassModel(MessageInterface messageInterface) {
        super(messageInterface, ClassModelHelper.implementationClassName(messageInterface), null);
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JCodeModel codeModel = super.generateModel();
        this.getDefinedClass()._implements(codeModel.ref(Serializable.class));
        JFieldVar serialVersionUID = this.getDefinedClass().field(28, (JType)codeModel.LONG, "serialVersionUID");
        serialVersionUID.init(JExpr.lit((long)1L));
        return codeModel;
    }

    void createBundleMethod(MessageMethod messageMethod, JMethod method, JMethod msgMethod, JVar projectCodeVar) {
        Object expression;
        JInvocation formatterMethod;
        this.addThrownTypes(messageMethod, method);
        JBlock body = method.body();
        JClass returnField = this.getCodeModel().ref(method.type().fullName());
        JVar result = body.decl((JType)returnField, "result");
        MessageMethod.Message message = messageMethod.message();
        boolean noFormatParameters = messageMethod.parameters(Parameter.ParameterType.FORMAT).isEmpty();
        switch (message.format()) {
            case MESSAGE_FORMAT: {
                String formattedId;
                JClass formatter = this.getCodeModel().ref(message.format().formatClass());
                formatterMethod = formatter.staticInvoke(message.format().staticMethod());
                if (message.hasId() && projectCodeVar != null && noFormatParameters) {
                    formattedId = ClassModelHelper.formatMessageId(message.id());
                    expression = projectCodeVar.plus(JExpr.lit((String)formattedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod));
                    break;
                }
                if (message.hasId() && projectCodeVar != null) {
                    formattedId = ClassModelHelper.formatMessageId(message.id());
                    formatterMethod.arg(projectCodeVar.plus(JExpr.lit((String)formattedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
                    expression = formatterMethod;
                    break;
                }
                if (noFormatParameters) {
                    expression = JExpr.invoke((JMethod)msgMethod);
                    break;
                }
                formatterMethod.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
                expression = formatterMethod;
                break;
            }
            case PRINTF: {
                String formattedId;
                JClass formatter = this.getCodeModel().ref(message.format().formatClass());
                formatterMethod = formatter.staticInvoke(message.format().staticMethod());
                if (message.hasId() && projectCodeVar != null) {
                    formattedId = ClassModelHelper.formatMessageId(message.id());
                    formatterMethod.arg(projectCodeVar.plus(JExpr.lit((String)formattedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
                    expression = formatterMethod;
                    break;
                }
                formatterMethod.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
                expression = formatterMethod;
                break;
            }
            default: {
                formatterMethod = null;
                expression = message.hasId() && projectCodeVar != null ? projectCodeVar.plus(JExpr.lit((String)ClassModelHelper.formatMessageId(message.id()))).plus((JExpression)JExpr.invoke((JMethod)msgMethod)) : JExpr.invoke((JMethod)msgMethod);
            }
        }
        HashMap<String, JVar> fields = new HashMap<String, JVar>();
        HashMap<String, JVar> properties = new HashMap<String, JVar>();
        for (Parameter parameter : messageMethod.parameters(Parameter.ParameterType.ANY)) {
            JClass paramType = this.getCodeModel().ref(parameter.type());
            JVar var = method.param(8, (JType)paramType, parameter.name());
            String formatterClass = parameter.formatterClass();
            switch (parameter.parameterType()) {
                case FORMAT: {
                    if (formatterMethod == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    if (formatterClass == null) {
                        formatterMethod.arg((JExpression)var);
                        break;
                    }
                    formatterMethod.arg((JExpression)JExpr._new((JClass)this.getCodeModel().ref(formatterClass)).arg((JExpression)var));
                    break;
                }
                case FIELD: {
                    fields.put(parameter.targetName(), var);
                    break;
                }
                case PROPERTY: {
                    properties.put(parameter.targetName(), var);
                }
            }
        }
        if (messageMethod.returnType().isThrowable()) {
            this.initCause(result, returnField, body, messageMethod, (JExpression)expression);
        } else {
            result.init((JExpression)expression);
        }
        for (Map.Entry entry : fields.entrySet()) {
            body.assign((JAssignmentTarget)result.ref((String)entry.getKey()), (JExpression)entry.getValue());
        }
        for (Map.Entry entry : properties.entrySet()) {
            body.add((JStatement)result.invoke((String)entry.getKey()).arg((JExpression)entry.getValue()));
        }
        body._return((JExpression)result);
    }

    private void initCause(JVar result, JClass returnField, JBlock body, MessageMethod messageMethod, JExpression format) {
        JInvocation initCause;
        ThrowableType returnType = messageMethod.returnType().throwableReturnType();
        if (returnType.useConstructionParameters()) {
            JInvocation invocation = JExpr._new((JClass)returnField);
            block3: for (Parameter param : returnType.constructionParameters()) {
                switch (param.parameterType()) {
                    case MESSAGE: {
                        invocation.arg(format);
                        continue block3;
                    }
                }
                invocation.arg((JExpression)JExpr.ref((String)param.name()));
            }
            result.init((JExpression)invocation);
        } else if (returnType.hasStringAndThrowableConstructor() && messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(format).arg((JExpression)JExpr.ref((String)messageMethod.cause().name())));
        } else if (returnType.hasThrowableAndStringConstructor() && messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)JExpr.ref((String)messageMethod.cause().name())).arg(format));
        } else if (returnType.hasStringConstructor()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(format));
            if (messageMethod.hasCause()) {
                initCause = body.invoke((JExpression)result, "initCause");
                initCause.arg((JExpression)JExpr.ref((String)messageMethod.cause().name()));
            }
        } else if (returnType.hasThrowableConstructor() && messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)JExpr.ref((String)messageMethod.cause().name())));
        } else if (returnType.hasStringAndThrowableConstructor() && !messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(format).arg(JExpr._null()));
        } else if (returnType.hasThrowableAndStringConstructor() && !messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(JExpr._null()).arg(format));
        } else if (messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField));
            initCause = body.invoke((JExpression)result, "initCause");
            initCause.arg((JExpression)JExpr.ref((String)messageMethod.cause().name()));
        } else {
            result.init((JExpression)JExpr._new((JClass)returnField));
        }
        JClass arrays = this.getCodeModel().ref(Arrays.class);
        JClass stClass = this.getCodeModel().ref(StackTraceElement.class).array();
        JVar st = body.decl((JType)stClass, "st").init((JExpression)result.invoke("getStackTrace"));
        JInvocation setStackTrace = result.invoke("setStackTrace");
        setStackTrace.arg((JExpression)arrays.staticInvoke("copyOfRange").arg((JExpression)st).arg(JExpr.lit((int)1)).arg((JExpression)st.ref("length")));
        body.add((JStatement)setStackTrace);
    }

    protected final void addThrownTypes(MessageMethod messageMethod, JMethod jMethod) {
        for (ThrowableType thrownType : messageMethod.thrownTypes()) {
            jMethod._throws(this.getCodeModel().ref(thrownType.name()));
        }
    }
}

