/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.processor.model.MessageObjectType;
import org.jboss.logging.processor.util.ElementHelper;

abstract class AbstractMessageObjectType
implements MessageObjectType {
    protected final Elements elements;
    protected final Types types;
    protected final TypeMirror typeMirror;

    protected AbstractMessageObjectType(Elements elements, Types types, TypeMirror typeMirror) {
        this.elements = elements;
        this.types = types;
        this.typeMirror = typeMirror;
    }

    protected AbstractMessageObjectType(Elements elements, Types types, Element element) {
        this.elements = elements;
        this.types = types;
        this.typeMirror = element.asType();
    }

    @Override
    public String type() {
        return this.name();
    }

    @Override
    public final boolean isAssignableFrom(Class<?> type) {
        TypeMirror typeMirror = this.elements.getTypeElement(ElementHelper.typeToString(type)).asType();
        return this.types.isAssignable(this.types.erasure(this.typeMirror), this.types.erasure(typeMirror));
    }

    @Override
    public final boolean isSubtypeOf(Class<?> type) {
        TypeMirror typeMirror = this.elements.getTypeElement(ElementHelper.typeToString(type)).asType();
        return this.types.isSubtype(this.types.erasure(this.typeMirror), this.types.erasure(typeMirror));
    }

    @Override
    public final boolean isSameAs(Class<?> type) {
        return this.type().equals(ElementHelper.typeToString(type));
    }
}

