/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.util.Map;
import javax.annotation.processing.Filer;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.generator.model.ClassModelHelper;
import org.jboss.logging.processor.generator.model.MessageBundleImplementor;
import org.jboss.logging.processor.generator.model.MessageBundleTranslator;
import org.jboss.logging.processor.generator.model.MessageLoggerImplementor;
import org.jboss.logging.processor.generator.model.MessageLoggerTranslator;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.util.TranslationHelper;

public class ClassModelFactory {
    private ClassModelFactory() {
    }

    public static ClassModel implementation(Filer filer, MessageInterface messageInterface, boolean useLogging31) throws IllegalArgumentException {
        switch (messageInterface.getAnnotatedType()) {
            case MESSAGE_BUNDLE: {
                return new MessageBundleImplementor(filer, messageInterface);
            }
            case MESSAGE_LOGGER: {
                return new MessageLoggerImplementor(filer, messageInterface, useLogging31);
            }
        }
        throw new IllegalArgumentException(String.format("Message interface %s is not a valid message logger or message bundle.", messageInterface));
    }

    public static ClassModel translation(Filer filer, MessageInterface messageInterface, String translationSuffix, Map<MessageMethod, String> translations) throws IllegalArgumentException {
        String generatedClassName = ClassModelHelper.implementationClassName(messageInterface, translationSuffix);
        String superClassName = TranslationHelper.getEnclosingTranslationClassName(generatedClassName);
        String locale = translationSuffix.substring(1);
        switch (messageInterface.getAnnotatedType()) {
            case MESSAGE_BUNDLE: {
                return new MessageBundleTranslator(filer, messageInterface, generatedClassName, superClassName, locale, translations);
            }
            case MESSAGE_LOGGER: {
                return new MessageLoggerTranslator(filer, messageInterface, generatedClassName, superClassName, locale, translations);
            }
        }
        throw new IllegalArgumentException(String.format("Message interface %s is not a valid message logger or message bundle.", messageInterface));
    }
}

