/*
 * JBoss, Home of Professional Open Source.
 *
 * Copyright 2023 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.logging.processor.report;

import org.jboss.logging.Logger.Level;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ResolutionDoc;

/**
 * Used for validating the XML for a {@code resolutionUrl} attribute.
 *
 * @author <a href="mailto:jperkins@redhat.com">James R. Perkins</a>
 */
@SuppressWarnings("unused")
@MessageLogger(projectCode = "RPTL", length = 5)
@ResolutionDoc
public interface TestReportLogger {

    @LogMessage(level = Level.INFO)
    @Message(id = 1, value = "Test message")
    @ResolutionDoc(suffix = ".html")
    void containsUrl();

    @LogMessage(level = Level.INFO)
    @Message("Test message")
    void noUrl();

    @LogMessage(level = Level.INFO)
    @Message(id = 2, value = "Test message")
    void defaultResolutionUrl();
}
