/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.model;

import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import java.text.MessageFormat;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.jboss.logging.Message;
import org.jboss.logging.model.ClassModelUtil;
import org.jboss.logging.model.ImplementationClassModel;
import org.jboss.logging.model.ImplementationType;
import org.jboss.logging.model.MethodDescriptor;
import org.jboss.logging.model.ReturnTypeDescriptor;
import org.jboss.logging.util.ElementHelper;

public class MessageBundleImplementor
extends ImplementationClassModel {
    public MessageBundleImplementor(String interfaceName, String projectCode) {
        super(interfaceName, projectCode, ImplementationType.BUNDLE);
    }

    @Override
    public void addMethod(ExecutableElement method) {
        super.addMethod(method);
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JCodeModel codeModel = super.generateModel();
        JFieldVar projectCodeVar = null;
        if (!this.getProjectCode().isEmpty()) {
            projectCodeVar = this.getDefinedClass().field(28, String.class, "projectCode");
            projectCodeVar.init(JExpr.lit((String)this.getProjectCode()));
        }
        this.getDefinedClass().constructor(2);
        ClassModelUtil.createReadResolveMethod(this.getDefinedClass());
        for (MethodDescriptor methodDesc : this.methodDescriptor) {
            JClass returnType = codeModel.ref(methodDesc.returnTypeAsString());
            JMethod jMethod = this.getDefinedClass().method(9, (JType)returnType, methodDesc.name());
            jMethod.annotate(Override.class);
            Message message = methodDesc.message();
            JMethod msgMethod = this.addMessageMethod(methodDesc.name(), message.value());
            JBlock body = jMethod.body();
            JClass returnField = codeModel.ref(returnType.fullName());
            JVar result = body.decl((JType)returnField, "result");
            JClass formatter = null;
            switch (message.format()) {
                case MESSAGE_FORMAT: {
                    formatter = codeModel.ref(MessageFormat.class);
                    break;
                }
                case PRINTF: {
                    formatter = codeModel.ref(String.class);
                }
            }
            JInvocation formatterMethod = formatter.staticInvoke("format");
            if (message.id() > 0 && projectCodeVar != null) {
                String formatedId = String.format("-%05d:", message.id());
                formatterMethod.arg(projectCodeVar.plus(JExpr.lit((String)formatedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
            } else {
                formatterMethod.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
            }
            for (VariableElement param : methodDesc.parameters()) {
                JClass paramType = codeModel.ref(((Object)param.asType()).toString());
                JVar paramVar = jMethod.param(8, (JType)paramType, param.getSimpleName().toString());
                if (ElementHelper.isAnnotatedWith(param, ElementHelper.CAUSE_ANNOTATION)) continue;
                formatterMethod.arg((JExpression)paramVar);
            }
            if (codeModel.ref(Throwable.class).isAssignableFrom(returnField)) {
                this.initCause(result, returnField, body, methodDesc, formatterMethod);
            } else {
                result.init((JExpression)formatterMethod);
            }
            body._return((JExpression)result);
        }
        return codeModel;
    }

    private void initCause(JVar result, JClass returnField, JBlock body, MethodDescriptor methodDesc, JInvocation formatterMethod) {
        ReturnTypeDescriptor desc = methodDesc.returnTypeDescriptor();
        if (desc.hasStringAndThrowableConstructor() && methodDesc.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)formatterMethod).arg((JExpression)JExpr.ref((String)methodDesc.causeVarName())));
        } else if (desc.hasThrowableAndStringConstructor() && methodDesc.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)JExpr.ref((String)methodDesc.causeVarName())).arg((JExpression)formatterMethod));
        } else if (desc.hasStringConsturctor()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)formatterMethod));
            JInvocation resultInv = body.invoke((JExpression)result, "initCause");
            resultInv.arg((JExpression)JExpr.ref((String)methodDesc.causeVarName()));
        } else if (desc.hasThrowableConstructor() && methodDesc.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(methodDesc.causeVarName()));
        } else if (methodDesc.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField));
            JInvocation resultInv = body.invoke((JExpression)result, "initCause");
            resultInv.arg((JExpression)JExpr.ref((String)methodDesc.causeVarName()));
        } else {
            result.init((JExpression)JExpr._new((JClass)returnField));
        }
    }
}

