/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.model;

import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.model.ImplementationClassModel;
import org.jboss.logging.model.ImplementationType;
import org.jboss.logging.model.MethodDescriptor;
import org.jboss.logging.util.BasicLoggerDescriptor;
import org.jboss.logging.util.ElementHelper;

public final class MessageLoggerImplementor
extends ImplementationClassModel {
    private static final String LOG_FIELD_NAME = "log";
    private final boolean extendsBasicLogger;
    private JFieldVar log;

    public MessageLoggerImplementor(String interfaceName, String projectCode, boolean extendsBasicLogger) {
        super(interfaceName, projectCode, ImplementationType.LOGGER);
        this.extendsBasicLogger = extendsBasicLogger;
    }

    @Override
    public void addMethod(ExecutableElement method) {
        super.addMethod(method);
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JCodeModel codeModel = super.generateModel();
        this.log = this.getDefinedClass().field(10, Logger.class, LOG_FIELD_NAME);
        JFieldVar projectCodeVar = null;
        if (!this.getProjectCode().isEmpty()) {
            projectCodeVar = this.getDefinedClass().field(28, String.class, "projectCode");
            projectCodeVar.init(JExpr.lit((String)this.getProjectCode()));
        }
        JMethod constructor = this.getDefinedClass().constructor(2);
        JVar constructorParam = constructor.param(8, Logger.class, LOG_FIELD_NAME);
        JBlock body = constructor.body();
        body.directStatement("this." + this.log.name() + " = " + constructorParam.name() + ";");
        for (MethodDescriptor methodDesc : this.methodDescriptor) {
            JClass returnType = codeModel.ref(methodDesc.returnTypeAsString());
            String methodName = methodDesc.name();
            JMethod jMethod = this.getDefinedClass().method(9, (JType)returnType, methodName);
            jMethod.annotate(Override.class);
            Message message = methodDesc.message();
            JMethod msgMethod = this.addMessageMethod(methodName, message.value());
            if (ElementHelper.isLoggerMethod(methodDesc.method())) {
                this.createLoggerMethod(methodDesc, jMethod, msgMethod, message.id(), (JVar)projectCodeVar);
                continue;
            }
            this.createBundleMethod(methodDesc, jMethod, msgMethod, message.id(), (JVar)projectCodeVar);
        }
        if (this.extendsBasicLogger) {
            this.implementBasicLogger(codeModel);
        }
        return codeModel;
    }

    private void createLoggerMethod(MethodDescriptor methodDesc, JMethod method, JMethod msgMethod, int messageId, JVar projectCodeVar) {
        LogMessage logMessage = methodDesc.logMessage();
        Logger.Level logLevel = Logger.Level.INFO;
        if (logMessage != null) {
            logLevel = logMessage.level();
        }
        JBlock body = method.body();
        StringBuilder logMethod = new StringBuilder(logLevel.name().toLowerCase());
        switch (methodDesc.message().format()) {
            case MESSAGE_FORMAT: {
                logMethod.append("v");
                break;
            }
            case PRINTF: {
                logMethod.append("f");
            }
        }
        JInvocation logInv = body.invoke((JExpression)this.log, logMethod.toString());
        if (methodDesc.hasCause()) {
            logInv.arg(JExpr.direct((String)methodDesc.causeVarName()));
        }
        if (messageId > 0 && projectCodeVar != null) {
            String formatedId = String.format("-%05d:", messageId);
            logInv.arg(projectCodeVar.plus(JExpr.lit((String)formatedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
        } else {
            logInv.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
        }
        for (VariableElement param : methodDesc.parameters()) {
            JClass paramType = this.getCodeModel().ref(((Object)param.asType()).toString());
            JVar var = method.param(8, (JType)paramType, param.getSimpleName().toString());
            if (param.equals(methodDesc.cause())) continue;
            logInv.arg((JExpression)var);
        }
    }

    private void createBundleMethod(MethodDescriptor methodDesc, JMethod method, JMethod msgMethod, int messageId, JVar projectCodeVar) {
        JBlock body = method.body();
        JClass returnField = this.getCodeModel().ref(method.type().fullName());
        JVar result = body.decl((JType)returnField, "result");
        JClass formatter = null;
        switch (methodDesc.message().format()) {
            case MESSAGE_FORMAT: {
                formatter = this.getCodeModel().ref(MessageFormat.class);
                break;
            }
            case PRINTF: {
                formatter = this.getCodeModel().ref(String.class);
            }
        }
        JInvocation formatterMethod = formatter.staticInvoke("format");
        if (messageId > 0 && projectCodeVar != null) {
            String formatedId = String.format("-%05d:", messageId);
            formatterMethod.arg(projectCodeVar.plus(JExpr.lit((String)formatedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
        } else {
            formatterMethod.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
        }
        for (VariableElement param : methodDesc.parameters()) {
            JClass paramType = this.getCodeModel().ref(((Object)param.asType()).toString());
            JVar paramVar = method.param(8, (JType)paramType, param.getSimpleName().toString());
            formatterMethod.arg((JExpression)paramVar);
        }
        result.init((JExpression)formatterMethod);
        body._return((JExpression)result);
    }

    private void implementBasicLogger(JCodeModel codeModel) {
        for (Method m : BasicLoggerDescriptor.getInstance().getMethods()) {
            if (!m.getReturnType().isPrimitive()) {
                codeModel.ref(m.getReturnType());
            }
            JMethod blMethod = this.getDefinedClass().method(9, m.getReturnType(), m.getName());
            blMethod.annotate(Override.class);
            int paramSize = m.getParameterTypes().length;
            int argCount = 0;
            StringBuilder blBody = new StringBuilder();
            if (!m.getReturnType().equals(Void.TYPE)) {
                blBody.append("return ");
            }
            blBody.append("this.").append(this.log.name()).append(".").append(m.getName()).append("(");
            for (Class<?> param : m.getParameterTypes()) {
                codeModel.ref(param);
                blMethod.param(8, param, "arg" + argCount);
                blBody.append("arg").append(argCount);
                if (++argCount >= paramSize) continue;
                blBody.append(", ");
            }
            blBody.append(");");
            blMethod.body().directStatement(blBody.toString());
        }
    }
}

