/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Message;
import org.jboss.logging.model.ReturnTypeDescriptor;

final class MethodDescriptor
implements Comparable<MethodDescriptor>,
Iterable<MethodDescriptor> {
    private final Set<MethodDescriptor> descriptors = new LinkedHashSet<MethodDescriptor>();
    private VariableElement cause;
    private ReturnTypeDescriptor returnTypeDescriptor;
    private LogMessage logMessage;
    private Message message;
    private final ExecutableElement method;
    private final String name;
    private final List<VariableElement> parameters;
    private TypeMirror returnType;

    public MethodDescriptor() {
        this(null, null);
    }

    private MethodDescriptor(MethodDescriptor methodDesc, ExecutableElement method) {
        this.method = method;
        this.name = method == null ? null : method.getSimpleName().toString();
        this.parameters = new ArrayList<VariableElement>();
        if (methodDesc != null) {
            this.descriptors.addAll(methodDesc.descriptors);
        }
    }

    public Message message() {
        return this.message;
    }

    public ExecutableElement method() {
        return this.method;
    }

    public String name() {
        return this.name;
    }

    public boolean hasCause() {
        return this.cause != null;
    }

    public VariableElement cause() {
        return this.cause;
    }

    public String causeVarName() {
        return this.cause().getSimpleName().toString();
    }

    public ReturnTypeDescriptor returnTypeDescriptor() {
        return this.returnTypeDescriptor;
    }

    public LogMessage logMessage() {
        return this.logMessage;
    }

    public Collection<VariableElement> parameters() {
        return Collections.unmodifiableCollection(this.parameters);
    }

    public TypeMirror returnType() {
        return this.returnType;
    }

    public String returnTypeAsString() {
        return ((Object)this.returnType).toString();
    }

    protected MethodDescriptor add(ExecutableElement method) {
        MethodDescriptor result = new MethodDescriptor(this, method);
        Message message = method.getAnnotation(Message.class);
        LogMessage logMessage = method.getAnnotation(LogMessage.class);
        result.returnType = method.getReturnType();
        if (result.returnType.getKind() != TypeKind.VOID) {
            try {
                result.returnTypeDescriptor = new ReturnTypeDescriptor(result.returnTypeAsString());
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(String.format("Return type %s for method %s is not in the classpath", result.method().getReturnType(), result.method()));
            }
        }
        Collection<MethodDescriptor> methodDescriptors = this.find(result.name());
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            if (methodDescriptor.message() != null && message == null) {
                message = methodDescriptor.message();
            }
            if (message == null) continue;
            break;
        }
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            if (methodDescriptor.message != null) continue;
            methodDescriptor.message = message;
            this.descriptors.remove(methodDescriptor);
            this.descriptors.add(methodDescriptor);
        }
        for (VariableElement variableElement : method.getParameters()) {
            if (variableElement.getAnnotation(Cause.class) != null) {
                result.cause = variableElement;
            }
            result.parameters.add(variableElement);
        }
        result.logMessage = logMessage;
        result.message = message;
        result.descriptors.add(result);
        return result;
    }

    public Collection<MethodDescriptor> find(String methodName) {
        LinkedHashSet<MethodDescriptor> result = new LinkedHashSet<MethodDescriptor>();
        for (MethodDescriptor methodDesc : this.descriptors) {
            if (!methodName.equals(methodDesc.name())) continue;
            result.add(methodDesc);
        }
        return result;
    }

    public void clear() {
        this.descriptors.clear();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodDescriptor)) {
            return false;
        }
        MethodDescriptor other = (MethodDescriptor)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("(name=");
        stringBuilder.append(this.name());
        stringBuilder.append(",message=");
        stringBuilder.append(this.message());
        stringBuilder.append(",logMessae=");
        stringBuilder.append(this.logMessage());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public Iterator<MethodDescriptor> iterator() {
        return this.descriptors.iterator();
    }

    @Override
    public int compareTo(MethodDescriptor o) {
        int c = this.method.getSimpleName().toString().compareTo(o.method.getSimpleName().toString());
        c = c != 0 ? c : this.method.getKind().compareTo(o.method.getKind());
        int n = c = c != 0 ? c : this.method.getParameters().size() - o.method.getParameters().size();
        if (c == 0) {
            List<? extends VariableElement> parms = this.method.getParameters();
            for (int i = 0; i < parms.size(); ++i) {
                VariableElement var1 = parms.get(i);
                VariableElement var2 = o.method.getParameters().get(i);
                c = var1.getKind().compareTo(var2.getKind());
            }
        }
        return c;
    }
}

