/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.model;

import java.lang.reflect.Constructor;

class ReturnTypeDescriptor {
    private final boolean primitive;
    private final Class<?> returnType;
    private final String returnTypeClassName;
    private boolean stringConsturctor = false;
    private boolean throwableConstructor = false;
    private boolean stringAndThrowableConstructor = false;
    private boolean throwableAndStringConstructor = false;

    public ReturnTypeDescriptor(String returnTypeClassName) throws ClassNotFoundException {
        this.returnTypeClassName = returnTypeClassName;
        this.returnType = Class.forName(returnTypeClassName);
        this.primitive = false;
        this.init();
    }

    public ReturnTypeDescriptor(String returnTypeName, boolean primitive) throws ClassNotFoundException {
        this.returnTypeClassName = returnTypeName;
        this.primitive = primitive;
        if (primitive) {
            this.returnType = null;
        } else {
            this.returnType = Class.forName(this.returnTypeClassName);
            this.init();
        }
    }

    private void init() {
        Constructor<?>[] constructors;
        block4: for (Constructor<?> construct : constructors = this.returnType.getConstructors()) {
            Class<?>[] params = construct.getParameterTypes();
            switch (params.length) {
                case 1: {
                    Class<String> param = params[0];
                    if (param.isAssignableFrom(String.class)) {
                        this.stringConsturctor = true;
                        continue block4;
                    }
                    if (!Throwable.class.isAssignableFrom(param)) continue block4;
                    this.throwableConstructor = true;
                    continue block4;
                }
                case 2: {
                    Class<String> param1 = params[0];
                    Class<String> param2 = params[1];
                    if (param1.isAssignableFrom(String.class) && Throwable.class.isAssignableFrom(param2)) {
                        this.stringAndThrowableConstructor = true;
                        continue block4;
                    }
                    if (!Throwable.class.isAssignableFrom(param1) || !param2.isAssignableFrom(String.class)) continue block4;
                    this.throwableAndStringConstructor = true;
                }
            }
        }
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public String getReturnTypeAsString() {
        return this.returnTypeClassName;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public boolean hasStringAndThrowableConstructor() {
        return this.stringAndThrowableConstructor;
    }

    public boolean hasStringConsturctor() {
        return this.stringConsturctor;
    }

    public boolean hasThrowableAndStringConstructor() {
        return this.throwableAndStringConstructor;
    }

    public boolean hasThrowableConstructor() {
        return this.throwableConstructor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        result = 31 * result + (this.stringConsturctor ? 1 : 0);
        result = 31 * result + (this.throwableConstructor ? 1 : 0);
        result = 31 * result + (this.stringAndThrowableConstructor ? 1 : 0);
        result = 31 * result + (this.throwableAndStringConstructor ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReturnTypeDescriptor)) {
            return false;
        }
        ReturnTypeDescriptor other = (ReturnTypeDescriptor)obj;
        if (this.returnType == null ? other.returnType != null : this.returnType.equals(other.returnType)) {
            return false;
        }
        return this.stringConsturctor == other.stringConsturctor && this.throwableConstructor == other.throwableConstructor && this.stringAndThrowableConstructor == other.stringAndThrowableConstructor && this.throwableAndStringConstructor == other.throwableAndStringConstructor;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName()).append("(returnType=").append(this.returnType).append(", stringConstructor=").append(this.stringConsturctor).append(", throwableConstructor=").append(this.throwableConstructor).append(", stringAndThrowableConstructor=").append(this.stringAndThrowableConstructor).append(", throwableAndStringConstructor=").append(this.throwableAndStringConstructor).append(")");
        return result.toString();
    }
}

