/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.validation.validator;

import java.util.ArrayList;
import java.util.Collection;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.util.ElementHelper;
import org.jboss.logging.validation.ElementValidator;
import org.jboss.logging.validation.ValidationErrorMessage;

public class BundleReturnTypeValidator
implements ElementValidator {
    @Override
    public Collection<ValidationErrorMessage> validate(TypeElement element, Collection<ExecutableElement> elementMethods) {
        ArrayList<ValidationErrorMessage> errorMessages = new ArrayList<ValidationErrorMessage>();
        if (ElementHelper.isAnnotatedWith(element, MessageBundle.class)) {
            for (ExecutableElement method : elementMethods) {
                try {
                    Class<String> returnClass = Class.forName(((Object)method.getReturnType()).toString());
                    if (Throwable.class.isAssignableFrom(returnClass) || returnClass.isAssignableFrom(String.class)) continue;
                    errorMessages.add(ValidationErrorMessage.of(method, "Message bundle %s has a method with invalid return type, method %s have return type of type %s", element, method, returnClass));
                }
                catch (ClassNotFoundException e) {
                    errorMessages.add(ValidationErrorMessage.of(method, "Return type %s for method %s is not in the classpath", method.getReturnType(), method));
                }
            }
        }
        return errorMessages;
    }
}

