/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.logging.metadata;

import java.util.List;

import java.util.logging.Handler;
import java.util.logging.Logger;

/**
 * A simple helper POJO which installs one or more handlers into a logger.
 */
public final class HandlerInstallerHelper {
    private List<Handler> handlerList;
    private List<Logger> targetList;

    public List<Handler> getHandlerList() {
        return handlerList;
    }

    public void setHandlerList(final List<Handler> handlerList) {
        this.handlerList = handlerList;
    }

    public List<Logger> getTargetList() {
        return targetList;
    }

    public void setTargetList(final List<Logger> targetList) {
        this.targetList = targetList;
    }

    public void start() {
        for (Handler handler : handlerList) {
            for (Logger target : targetList) {
                target.addHandler(handler);
            }
        }
    }

    public void stop() {
        for (Handler handler : handlerList) {
            for (Logger target : targetList) {
                target.removeHandler(handler);
            }
        }
    }

    public void destroy() {
        targetList = null;
        handlerList = null;
    }
}
