/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.filters;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LevelExcludingFilter
implements Filter {
    private final Set<Level> excludedLevels;

    public LevelExcludingFilter(Level excludedLevel) {
        this.excludedLevels = Collections.singleton(excludedLevel);
    }

    public LevelExcludingFilter(Collection<Level> excludedLevels) {
        this.excludedLevels = new HashSet<Level>(excludedLevels);
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return !this.excludedLevels.contains(record.getLevel());
    }
}

