/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Handler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.ArrayQueue;
import org.jboss.logmanager.handlers.ExtHandler;

public final class AsyncHandler
extends ExtHandler {
    private final CopyOnWriteArrayList<Handler> handlers = new CopyOnWriteArrayList();
    private final ThreadFactory threadFactory;
    private final Queue<ExtLogRecord> recordQueue;
    private final AsyncThread asyncThread = new AsyncThread();
    private boolean closed;
    private boolean taskRunning;
    private static final int DEFAULT_QUEUE_LENGTH = 512;

    public AsyncHandler(int queueLength, ThreadFactory threadFactory) {
        this.recordQueue = new ArrayQueue<ExtLogRecord>(queueLength);
        this.threadFactory = threadFactory;
    }

    public AsyncHandler(ThreadFactory threadFactory) {
        this(512, threadFactory);
    }

    public AsyncHandler(int queueLength) {
        this(queueLength, Executors.defaultThreadFactory());
    }

    public AsyncHandler() {
        this(512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(Handler handler) {
        this.checkAccess();
        Queue<ExtLogRecord> queue = this.recordQueue;
        synchronized (queue) {
            if (this.closed) {
                throw new IllegalStateException("Handler is closed");
            }
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(Handler handler) {
        this.checkAccess();
        Queue<ExtLogRecord> queue = this.recordQueue;
        synchronized (queue) {
            if (!this.closed) {
                this.handlers.remove(handler);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void publish(ExtLogRecord record) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void startTaskIfNotRunning() {
        if (!this.taskRunning) {
            this.taskRunning = true;
            this.threadFactory.newThread(this.asyncThread).start();
        }
    }

    public void flush() {
        for (Handler handler : this.handlers) {
            handler.flush();
        }
    }

    public void close() throws SecurityException {
        this.checkAccess();
        this.closed = true;
        this.asyncThread.interrupt();
        this.handlers.clear();
    }

    static /* synthetic */ Queue access$100(AsyncHandler x0) {
        return x0.recordQueue;
    }

    static /* synthetic */ CopyOnWriteArrayList access$200(AsyncHandler x0) {
        return x0.handlers;
    }

    static /* synthetic */ boolean access$300(AsyncHandler x0) {
        return x0.closed;
    }

    static /* synthetic */ boolean access$402(AsyncHandler x0, boolean x1) {
        x0.taskRunning = x1;
        return x0.taskRunning;
    }

    private final class AsyncThread
    implements Runnable {
        private volatile Thread thread;

        private AsyncThread() {
        }

        void interrupt() {
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.thread = Thread.currentThread();
            recordQueue = AsyncHandler.access$100(AsyncHandler.this);
            handlers = AsyncHandler.access$200(AsyncHandler.this);
            intr = false;
            block17: while (true) {
                var5_5 = recordQueue;
                synchronized (var5_5) {
                    while ((rec = (ExtLogRecord)recordQueue.poll()) == null) {
                        if (AsyncHandler.access$300(AsyncHandler.this)) {
                            return;
                        }
                        try {
                            recordQueue.wait();
                        }
                        catch (InterruptedException e) {
                            intr = true;
                        }
                    }
                    recordQueue.notify();
                }
                i$ = handlers.iterator();
                while (true) lbl-1000:
                // 4 sources

                {
                    if (!i$.hasNext()) continue block17;
                    handler = (Handler)i$.next();
                    try {
                        handler.publish(rec);
                    }
                    catch (Exception e) {
                        AsyncHandler.this.getErrorManager().error("Publication error", e, 1);
                    }
                    catch (VirtualMachineError e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        continue;
                    }
                    break;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                var6_6 = recordQueue;
                synchronized (var6_6) {
                    AsyncHandler.access$402(AsyncHandler.this, false);
                    recordQueue.notify();
                }
                this.thread = null;
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

