/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.Permission;
import java.util.logging.Formatter;
import java.util.logging.LoggingPermission;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.formatters.Formatters;
import org.jboss.logmanager.handlers.ExtHandler;

public class OutputStreamHandler
extends ExtHandler {
    private volatile boolean autoFlush = false;
    private final Object outputLock = new Object();
    private OutputStream outputStream;
    private Writer writer;
    private static final Permission CONTROL_PERMISSION = new LoggingPermission("control", null);

    public OutputStreamHandler() {
        this.setFormatter(Formatters.nullFormatter());
    }

    public OutputStreamHandler(Formatter formatter) {
        this.setFormatter(formatter);
    }

    public OutputStreamHandler(OutputStream outputStream, Formatter formatter) {
        this.setFormatter(formatter);
        this.setOutputStream(outputStream);
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) throws SecurityException {
        OutputStreamHandler.checkControl();
        this.autoFlush = autoFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        OutputStreamHandler.checkControl();
        super.setEncoding(encoding);
        Object object = this.outputLock;
        synchronized (object) {
            Writer writer = this.writer;
            if (writer == null) {
                return;
            }
            this.closeWriter();
            this.writer = encoding == null ? new OutputStreamWriter(this.outputStream) : new OutputStreamWriter(this.outputStream, encoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputStream(OutputStream newOutputStream) {
        OutputStreamWriter newWriter;
        OutputStreamHandler.checkControl();
        if (newOutputStream == null) {
            this.closeStream();
            return;
        }
        try {
            String encoding = this.getEncoding();
            newWriter = encoding == null ? new OutputStreamWriter(newOutputStream) : new OutputStreamWriter(newOutputStream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("The specified encoding is invalid");
        }
        catch (Exception e) {
            this.reportError("Error opeing output stream", e, 4);
            return;
        }
        Object object = this.outputLock;
        synchronized (object) {
            this.closeStream();
            this.outputStream = newOutputStream;
            this.writer = newWriter;
            try {
                this.writer.write(this.getFormatter().getHead(this));
            }
            catch (Exception e) {
                this.reportError("Error writing section header", e, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(ExtLogRecord record) {
        if (this.isLoggable(record)) {
            String formatted;
            Formatter formatter = this.getFormatter();
            try {
                formatted = formatter.format(record);
            }
            catch (Exception ex) {
                this.reportError("Formatting error", ex, 5);
                return;
            }
            try {
                Object ex = this.outputLock;
                synchronized (ex) {
                    Writer writer = this.writer;
                    if (writer == null) {
                        return;
                    }
                    writer.write(formatted);
                }
            }
            catch (Exception ex) {
                this.reportError("Error writing log message", ex, 1);
                return;
            }
            if (this.autoFlush) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.outputLock;
        synchronized (object) {
            this.safeFlush(this.writer);
        }
    }

    private void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            this.reportError("Error closing resource", e, 3);
        }
    }

    private void safeFlush(Flushable f) {
        try {
            if (f != null) {
                f.flush();
            }
        }
        catch (IOException e) {
            this.reportError("Error on flush", e, 2);
        }
    }

    private void closeWriter() {
        this.safeFlush(this.writer);
        this.writer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStream() {
        Object object = this.outputLock;
        synchronized (object) {
            Writer writer = this.writer;
            if (writer == null) {
                return;
            }
            try {
                writer.write(this.getFormatter().getTail(this));
            }
            catch (Exception ex) {
                this.reportError("Error writing section tail", ex, 1);
            }
            this.safeFlush(writer);
            this.safeClose(writer);
            this.writer = null;
            this.outputStream = null;
        }
    }

    public void close() throws SecurityException {
        OutputStreamHandler.checkControl();
        this.closeStream();
    }

    private static void checkControl() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
    }
}

