/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Handler;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.ArrayQueue;

public class AsyncHandler
extends ExtHandler {
    private final ThreadFactory threadFactory;
    private final Queue<ExtLogRecord> recordQueue;
    private final AsyncThread asyncThread = new AsyncThread();
    private volatile OverflowAction overflowAction = OverflowAction.BLOCK;
    private boolean closed;
    private boolean taskRunning;
    private static final int DEFAULT_QUEUE_LENGTH = 512;

    public AsyncHandler(int queueLength, ThreadFactory threadFactory) {
        this.recordQueue = new ArrayQueue<ExtLogRecord>(queueLength);
        this.threadFactory = threadFactory;
    }

    public AsyncHandler(ThreadFactory threadFactory) {
        this(512, threadFactory);
    }

    public AsyncHandler(int queueLength) {
        this(queueLength, Executors.defaultThreadFactory());
    }

    public AsyncHandler() {
        this(512);
    }

    public OverflowAction getOverflowAction() {
        return this.overflowAction;
    }

    public void setOverflowAction(OverflowAction overflowAction) {
        if (overflowAction == null) {
            throw new NullPointerException("overflowAction is null");
        }
        AsyncHandler.checkAccess();
        this.overflowAction = overflowAction;
    }

    /*
     * Exception decompiling
     */
    protected void doPublish(ExtLogRecord record) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void startTaskIfNotRunning() {
        if (!this.taskRunning) {
            this.taskRunning = true;
            this.threadFactory.newThread(this.asyncThread).start();
        }
    }

    public void flush() {
        for (Handler handler : this.handlers) {
            handler.flush();
        }
    }

    public void close() throws SecurityException {
        AsyncHandler.checkAccess();
        this.closed = true;
        this.asyncThread.interrupt();
        this.clearHandlers();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OverflowAction {
        BLOCK,
        DISCARD;

    }

    private final class AsyncThread
    implements Runnable {
        private volatile Thread thread;

        private AsyncThread() {
        }

        void interrupt() {
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.thread = Thread.currentThread();
            Queue recordQueue = AsyncHandler.this.recordQueue;
            Handler[] handlers = AsyncHandler.this.handlers;
            boolean intr = false;
            try {
                block17: while (true) {
                    ExtLogRecord rec;
                    Queue queue = recordQueue;
                    synchronized (queue) {
                        while ((rec = (ExtLogRecord)recordQueue.poll()) == null) {
                            if (AsyncHandler.this.closed) {
                                return;
                            }
                            try {
                                recordQueue.wait();
                            }
                            catch (InterruptedException e) {
                                intr = true;
                            }
                        }
                        recordQueue.notify();
                    }
                    Handler[] arr$ = handlers;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) continue block17;
                        Handler handler = arr$[i$];
                        try {
                            handler.publish(rec);
                        }
                        catch (Exception e) {
                            AsyncHandler.this.getErrorManager().error("Publication error", e, 1);
                        }
                        catch (VirtualMachineError e) {
                            throw e;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        ++i$;
                    }
                    break;
                }
            }
            finally {
                Queue queue = recordQueue;
                synchronized (queue) {
                    AsyncHandler.this.taskRunning = false;
                    recordQueue.notify();
                }
                this.thread = null;
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

