/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.logmanager.MDC;
import org.jboss.logmanager.NDC;

public class ExtLogRecord
extends LogRecord {
    private static final long serialVersionUID = -9174374711278052369L;
    private final String ndc;
    private final transient String loggerClassName;
    private transient boolean calculateCaller = true;
    private FormatStyle formatStyle = FormatStyle.MESSAGE_FORMAT;
    private Map<String, String> mdcCopy;
    private int sourceLineNumber = -1;
    private String sourceFileName;
    private String resourceKey;
    private String formattedMessage;
    private String threadName;

    public ExtLogRecord(Level level, String msg, String loggerClassName) {
        this(level, msg, FormatStyle.MESSAGE_FORMAT, loggerClassName);
    }

    public ExtLogRecord(Level level, String msg, FormatStyle formatStyle, String loggerClassName) {
        super(level, msg);
        this.formatStyle = formatStyle == null ? FormatStyle.MESSAGE_FORMAT : formatStyle;
        this.loggerClassName = loggerClassName;
        this.ndc = NDC.get();
        this.threadName = Thread.currentThread().getName();
    }

    public ExtLogRecord(LogRecord original, String loggerClassName) {
        this(original.getLevel(), original.getMessage(), loggerClassName);
        this.setLoggerName(original.getLoggerName());
        this.setMillis(original.getMillis());
        this.setParameters(original.getParameters());
        this.setResourceBundle(original.getResourceBundle());
        this.setResourceBundleName(original.getResourceBundleName());
        this.setSequenceNumber(original.getSequenceNumber());
        this.setThreadID(original.getThreadID());
        this.setThrown(original.getThrown());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.copyAll();
        oos.defaultWriteObject();
    }

    public void disableCallerCalculation() {
        if (this.calculateCaller) {
            this.setUnknownCaller();
        }
    }

    public void copyAll() {
        this.copyMdc();
        this.calculateCaller();
        this.getFormattedMessage();
    }

    public void copyMdc() {
        if (this.mdcCopy == null) {
            this.mdcCopy = MDC.copy();
        }
    }

    public String getMdc(String key) {
        Map<String, String> mdcCopy = this.mdcCopy;
        return mdcCopy != null ? mdcCopy.get(key) : MDC.get(key);
    }

    public String getNdc() {
        return this.ndc;
    }

    public String getLoggerClassName() {
        return this.loggerClassName;
    }

    private void calculateCaller() {
        if (!this.calculateCaller) {
            return;
        }
        this.calculateCaller = false;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        boolean found = false;
        for (StackTraceElement element : stack) {
            String className = element.getClassName();
            if (found) {
                if (this.loggerClassName.equals(className)) continue;
                this.setSourceClassName(className);
                this.setSourceMethodName(element.getMethodName());
                this.setSourceLineNumber(element.getLineNumber());
                this.setSourceFileName(element.getFileName());
                return;
            }
            found = this.loggerClassName.equals(className);
        }
        this.setUnknownCaller();
    }

    private void setUnknownCaller() {
        this.setSourceClassName("<unknown>");
        this.setSourceMethodName("<unknown>");
        this.setSourceLineNumber(-1);
        this.setSourceFileName("<unknown>");
    }

    public int getSourceLineNumber() {
        this.calculateCaller();
        return this.sourceLineNumber;
    }

    public void setSourceLineNumber(int sourceLineNumber) {
        this.calculateCaller = false;
        this.sourceLineNumber = sourceLineNumber;
    }

    public String getSourceFileName() {
        this.calculateCaller();
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.calculateCaller = false;
        this.sourceFileName = sourceFileName;
    }

    @Override
    public String getSourceClassName() {
        this.calculateCaller();
        return super.getSourceClassName();
    }

    @Override
    public void setSourceClassName(String sourceClassName) {
        this.calculateCaller = false;
        super.setSourceClassName(sourceClassName);
    }

    @Override
    public String getSourceMethodName() {
        this.calculateCaller();
        return super.getSourceMethodName();
    }

    @Override
    public void setSourceMethodName(String sourceMethodName) {
        this.calculateCaller = false;
        super.setSourceMethodName(sourceMethodName);
    }

    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            this.formattedMessage = this.formatRecord();
        }
        return this.formattedMessage;
    }

    public String getResourceKey() {
        if (this.formattedMessage == null) {
            this.formatRecord();
        }
        return this.resourceKey;
    }

    private String formatRecord() {
        Object[] parameters;
        ResourceBundle bundle = this.getResourceBundle();
        String msg = this.getMessage();
        if (bundle != null) {
            try {
                String locMsg = bundle.getString(msg);
                this.resourceKey = msg;
                msg = locMsg;
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        if ((parameters = this.getParameters()) == null || parameters.length == 0) {
            return msg;
        }
        switch (this.formatStyle) {
            case PRINTF: {
                return String.format(msg, parameters);
            }
            case MESSAGE_FORMAT: {
                return msg.indexOf(123) >= 0 ? MessageFormat.format(msg, parameters) : msg;
            }
        }
        return msg;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    @Override
    public void setMessage(String message) {
        this.setMessage(message, FormatStyle.MESSAGE_FORMAT);
    }

    public void setMessage(String message, FormatStyle formatStyle) {
        this.formatStyle = formatStyle == null ? FormatStyle.MESSAGE_FORMAT : formatStyle;
        this.formattedMessage = null;
        super.setMessage(message);
    }

    @Override
    public void setParameters(Object[] parameters) {
        this.formattedMessage = null;
        super.setParameters(parameters);
    }

    @Override
    public void setResourceBundle(ResourceBundle bundle) {
        this.formattedMessage = null;
        super.setResourceBundle(bundle);
    }

    @Override
    public void setResourceBundleName(String name) {
        this.formattedMessage = null;
        super.setResourceBundleName(name);
    }

    public static enum FormatStyle {
        MESSAGE_FORMAT,
        PRINTF;

    }
}

