/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jboss.logmanager.config.AbstractBasicConfiguration;
import org.jboss.logmanager.config.ConfigAction;
import org.jboss.logmanager.config.LogContextConfigurationImpl;
import org.jboss.logmanager.config.ObjectConfigurable;
import org.jboss.logmanager.config.ObjectProducer;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.logmanager.config.ValueExpression;
import org.jboss.logmanager.config.ValueExpressionImpl;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

abstract class AbstractPropertyConfiguration<T, C extends AbstractPropertyConfiguration<T, C>>
extends AbstractBasicConfiguration<T, C>
implements ObjectConfigurable,
PropertyConfigurable {
    private final Class<? extends T> actualClass;
    private final String moduleName;
    private final String className;
    private final String[] constructorProperties;
    private final Map<String, ValueExpression<String>> properties = new LinkedHashMap<String, ValueExpression<String>>(0);
    private final Map<String, Method> postConfigurationMethods = new LinkedHashMap<String, Method>();

    protected AbstractPropertyConfiguration(Class<T> baseClass, LogContextConfigurationImpl configuration, Map<String, T> refs, Map<String, C> configs, String name, String moduleName, String className, String[] constructorProperties) {
        super(name, configuration, refs, configs);
        Class<T> actualClass;
        ClassLoader classLoader;
        this.moduleName = moduleName;
        this.className = className;
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        this.constructorProperties = constructorProperties;
        if (moduleName != null) {
            try {
                classLoader = ModuleFinder.getClassLoader(moduleName);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(String.format("Failed to load module \"%s\" for %s \"%s\"", moduleName, this.getDescription(), name), e);
            }
        } else {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            actualClass = Class.forName(className, true, classLoader).asSubclass(baseClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Failed to load class \"%s\" for %s \"%s\"", className, this.getDescription(), name), e);
        }
        this.actualClass = actualClass;
    }

    ConfigAction<T> getConstructAction() {
        return new ConstructAction();
    }

    abstract String getDescription();

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    static boolean contains(Object[] array, Object val) {
        for (Object o : array) {
            if (!o.equals(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setPropertyValueString(String propertyName, String value) throws IllegalArgumentException {
        if (this.isRemoved()) {
            throw new IllegalArgumentException(String.format("Cannot set property \"%s\" on %s \"%s\" (removed)", propertyName, this.getDescription(), this.getName()));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is null");
        }
        this.setPropertyValueExpression(propertyName, ValueExpression.STRING_RESOLVER.resolve(value));
    }

    @Override
    public String getPropertyValueString(String propertyName) {
        return this.getPropertyValueExpression(propertyName).getResolvedValue();
    }

    @Override
    public ValueExpression<String> getPropertyValueExpression(String propertyName) {
        return this.properties.containsKey(propertyName) ? this.properties.get(propertyName) : ValueExpression.NULL_STRING_EXPRESSION;
    }

    @Override
    public void setPropertyValueExpression(String propertyName, String expression) {
        if (this.isRemoved()) {
            throw new IllegalArgumentException(String.format("Cannot set property \"%s\" on %s \"%s\" (removed)", propertyName, this.getDescription(), this.getName()));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is null");
        }
        this.setPropertyValueExpression(propertyName, ValueExpression.STRING_RESOLVER.resolve(expression));
    }

    @Override
    public void setPropertyValueExpression(String propertyName, String expression, String value) {
        if (this.isRemoved()) {
            throw new IllegalArgumentException(String.format("Cannot set property \"%s\" on %s \"%s\" (removed)", propertyName, this.getDescription(), this.getName()));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is null");
        }
        this.setPropertyValueExpression(propertyName, new ValueExpressionImpl<String>(expression, value));
    }

    private void setPropertyValueExpression(final String propertyName, final ValueExpression<String> expression) {
        final boolean replacement = this.properties.containsKey(propertyName);
        boolean constructorProp = AbstractPropertyConfiguration.contains(this.constructorProperties, propertyName);
        final Method setter = AbstractPropertyConfiguration.getPropertySetter(this.actualClass, propertyName);
        if (setter == null && !constructorProp) {
            throw new IllegalArgumentException(String.format("No property \"%s\" setter found for %s \"%s\"", propertyName, this.getDescription(), this.getName()));
        }
        final ValueExpression<String> oldValue = this.properties.put(propertyName, expression);
        this.getConfiguration().addAction(new ConfigAction<ObjectProducer>(){

            @Override
            public ObjectProducer validate() throws IllegalArgumentException {
                if (setter == null) {
                    return ObjectProducer.NULL_PRODUCER;
                }
                Class<?> propertyType = AbstractPropertyConfiguration.getPropertyType(AbstractPropertyConfiguration.this.actualClass, propertyName);
                if (propertyType == null) {
                    throw new IllegalArgumentException(String.format("No property \"%s\" type could be determined for %s \"%s\"", propertyName, AbstractPropertyConfiguration.this.getDescription(), AbstractPropertyConfiguration.this.getName()));
                }
                return AbstractPropertyConfiguration.this.getConfiguration().getValue(AbstractPropertyConfiguration.this.actualClass, propertyName, propertyType, expression, false);
            }

            @Override
            public void applyPreCreate(ObjectProducer param) {
                AbstractPropertyConfiguration.this.addPostConfigurationActions();
            }

            @Override
            public void applyPostCreate(ObjectProducer param) {
                if (setter != null) {
                    Object instance = AbstractPropertyConfiguration.this.getRefs().get(AbstractPropertyConfiguration.this.getName());
                    try {
                        setter.invoke(instance, param.getObject());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void rollback() {
                if (replacement) {
                    AbstractPropertyConfiguration.this.properties.put(propertyName, oldValue);
                } else {
                    AbstractPropertyConfiguration.this.properties.remove(propertyName);
                }
            }
        });
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeProperty(String propertyName) {
        if (this.isRemoved()) {
            throw new IllegalArgumentException(String.format("Cannot remove property \"%s\" on %s \"%s\" (removed)", propertyName, this.getDescription(), this.getName()));
        }
        try {
            boolean bl = this.properties.containsKey(propertyName);
            return bl;
        }
        finally {
            this.properties.remove(propertyName);
        }
    }

    @Override
    public List<String> getPropertyNames() {
        return new ArrayList<String>(this.properties.keySet());
    }

    @Override
    public boolean hasConstructorProperty(String propertyName) {
        return AbstractPropertyConfiguration.contains(this.constructorProperties, propertyName);
    }

    Class<? extends T> getActualClass() {
        return this.actualClass;
    }

    @Override
    public List<String> getConstructorProperties() {
        return Arrays.asList(this.constructorProperties);
    }

    @Override
    public boolean addPostConfigurationMethod(final String methodName) {
        LogContextConfigurationImpl configuration = this.getConfiguration();
        if (this.postConfigurationMethods.containsKey(methodName)) {
            return false;
        }
        configuration.addAction(new ConfigAction<Method>(){

            @Override
            public Method validate() throws IllegalArgumentException {
                try {
                    return AbstractPropertyConfiguration.this.actualClass.getMethod(methodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException(String.format("Method '%s' not found on '%s'", methodName, AbstractPropertyConfiguration.this.actualClass.getName()));
                }
            }

            @Override
            public void applyPreCreate(Method param) {
            }

            @Override
            public void applyPostCreate(Method param) {
                AbstractPropertyConfiguration.this.postConfigurationMethods.put(methodName, param);
                AbstractPropertyConfiguration.this.addPostConfigurationActions(true);
            }

            @Override
            public void rollback() {
                AbstractPropertyConfiguration.this.postConfigurationMethods.remove(methodName);
                AbstractPropertyConfiguration.this.addPostConfigurationActions(true);
            }
        });
        return true;
    }

    @Override
    public List<String> getPostConfigurationMethods() {
        return new ArrayList<String>(this.postConfigurationMethods.keySet());
    }

    @Override
    public void setPostConfigurationMethods(String ... methodNames) {
        this.setPostConfigurationMethods(Arrays.asList(methodNames));
    }

    @Override
    public void setPostConfigurationMethods(List<String> methodNames) {
        final LinkedHashMap<String, Method> oldMethods = new LinkedHashMap<String, Method>(this.postConfigurationMethods);
        this.postConfigurationMethods.clear();
        final LinkedHashSet<String> names = new LinkedHashSet<String>(methodNames);
        this.getConfiguration().addAction(new ConfigAction<Map<String, Method>>(){

            @Override
            public Map<String, Method> validate() throws IllegalArgumentException {
                LinkedHashMap<String, Method> result = new LinkedHashMap<String, Method>();
                for (String methodName : names) {
                    try {
                        result.put(methodName, AbstractPropertyConfiguration.this.actualClass.getMethod(methodName, new Class[0]));
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalArgumentException(String.format("Method '%s' not found on '%s'", methodName, AbstractPropertyConfiguration.this.actualClass.getName()));
                    }
                }
                return result;
            }

            @Override
            public void applyPreCreate(Map<String, Method> param) {
            }

            @Override
            public void applyPostCreate(Map<String, Method> param) {
                AbstractPropertyConfiguration.this.postConfigurationMethods.clear();
                AbstractPropertyConfiguration.this.postConfigurationMethods.putAll(param);
                AbstractPropertyConfiguration.this.addPostConfigurationActions(true);
            }

            @Override
            public void rollback() {
                AbstractPropertyConfiguration.this.postConfigurationMethods.clear();
                AbstractPropertyConfiguration.this.postConfigurationMethods.putAll(oldMethods);
                AbstractPropertyConfiguration.this.addPostConfigurationActions(true);
            }
        });
    }

    @Override
    public boolean removePostConfigurationMethod(final String methodName) {
        LogContextConfigurationImpl configuration = this.getConfiguration();
        if (!this.postConfigurationMethods.containsKey(methodName)) {
            return false;
        }
        final Method method = this.postConfigurationMethods.get(methodName);
        this.postConfigurationMethods.remove(methodName);
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
            }

            @Override
            public void applyPostCreate(Void param) {
            }

            @Override
            public void rollback() {
                AbstractPropertyConfiguration.this.postConfigurationMethods.put(methodName, method);
                AbstractPropertyConfiguration.this.addPostConfigurationActions(true);
            }
        });
        return true;
    }

    protected final void addPostConfigurationActions() {
        this.addPostConfigurationActions(false);
    }

    private void addPostConfigurationActions(boolean replace) {
        String name = this.className + "." + this.getName();
        LogContextConfigurationImpl configuration = this.getConfiguration();
        if (!replace && configuration.postConfigurationActionsExist(name)) {
            return;
        }
        ArrayDeque queue = new ArrayDeque(this.postConfigurationMethods.size());
        for (final String methodName : this.postConfigurationMethods.keySet()) {
            ConfigAction<Method> configAction = new ConfigAction<Method>(){

                @Override
                public Method validate() throws IllegalArgumentException {
                    Method result = (Method)AbstractPropertyConfiguration.this.postConfigurationMethods.get(methodName);
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Method '%s' not found on '%s'", methodName, AbstractPropertyConfiguration.this.actualClass.getName()));
                    }
                    return result;
                }

                @Override
                public void applyPreCreate(Method param) {
                }

                @Override
                public void applyPostCreate(Method param) {
                    Object instance = AbstractPropertyConfiguration.this.getRefs().get(AbstractPropertyConfiguration.this.getName());
                    try {
                        param.invoke(instance, new Object[0]);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void rollback() {
                }
            };
            queue.addLast(configAction);
        }
        configuration.addPostConfigurationActions(name, queue);
    }

    protected final Deque<?> removePostConfigurationActions() {
        String name = this.className + "." + this.getName();
        return this.getConfiguration().removePostConfigurationActions(name);
    }

    static Class<?> getPropertyType(Class<?> clazz, String propertyName) {
        Method setter = AbstractPropertyConfiguration.getPropertySetter(clazz, propertyName);
        return setter != null ? setter.getParameterTypes()[0] : null;
    }

    static Class<?> getConstructorPropertyType(Class<?> clazz, String propertyName) {
        Method getter = AbstractPropertyConfiguration.getPropertyGetter(clazz, propertyName);
        return getter != null ? getter.getReturnType() : AbstractPropertyConfiguration.getPropertyType(clazz, propertyName);
    }

    static Method getPropertySetter(Class<?> clazz, String propertyName) {
        String upperPropertyName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String set = "set" + upperPropertyName;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(set) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    static Method getPropertyGetter(Class<?> clazz, String propertyName) {
        String upperPropertyName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String get = "get" + upperPropertyName;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(get) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        return null;
    }

    static class ModuleFinder {
        private ModuleFinder() {
        }

        static ClassLoader getClassLoader(String moduleName) throws Exception {
            ModuleLoader moduleLoader = ModuleLoader.forClass(ModuleFinder.class);
            if (moduleLoader == null) {
                moduleLoader = Module.getBootModuleLoader();
            }
            return moduleLoader.loadModule(ModuleIdentifier.create((String)moduleName)).getClassLoader();
        }
    }

    class ConstructAction
    implements ConfigAction<T> {
        ConstructAction() {
        }

        @Override
        public T validate() throws IllegalArgumentException {
            Constructor constructor;
            int length = AbstractPropertyConfiguration.this.constructorProperties.length;
            Class[] paramTypes = new Class[length];
            for (int i = 0; i < length; ++i) {
                String property = AbstractPropertyConfiguration.this.constructorProperties[i];
                Class<?> type = AbstractPropertyConfiguration.getConstructorPropertyType(AbstractPropertyConfiguration.this.actualClass, property);
                if (type == null) {
                    throw new IllegalArgumentException(String.format("No property named \"%s\" for %s \"%s\"", property, AbstractPropertyConfiguration.this.getDescription(), AbstractPropertyConfiguration.this.getName()));
                }
                paramTypes[i] = type;
            }
            try {
                constructor = AbstractPropertyConfiguration.this.actualClass.getConstructor(paramTypes);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Failed to locate constructor in class \"%s\" for %s \"%s\"", AbstractPropertyConfiguration.this.className, AbstractPropertyConfiguration.this.getDescription(), AbstractPropertyConfiguration.this.getName()), e);
            }
            Object[] params = new Object[length];
            for (int i = 0; i < length; ++i) {
                Object value;
                String property = AbstractPropertyConfiguration.this.constructorProperties[i];
                if (!AbstractPropertyConfiguration.this.properties.containsKey(property)) {
                    throw new IllegalArgumentException(String.format("No property named \"%s\" is configured on %s \"%s\"", property, AbstractPropertyConfiguration.this.getDescription(), AbstractPropertyConfiguration.this.getName()));
                }
                ValueExpression valueExpression = (ValueExpression)AbstractPropertyConfiguration.this.properties.get(property);
                params[i] = value = AbstractPropertyConfiguration.this.getConfiguration().getValue(AbstractPropertyConfiguration.this.actualClass, property, paramTypes[i], valueExpression, true).getObject();
            }
            try {
                return constructor.newInstance(params);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Failed to instantiate class \"%s\" for %s \"%s\"", AbstractPropertyConfiguration.this.className, AbstractPropertyConfiguration.this.getDescription(), AbstractPropertyConfiguration.this.getName()), e);
            }
        }

        @Override
        public void applyPreCreate(T param) {
            AbstractPropertyConfiguration.this.getRefs().put(AbstractPropertyConfiguration.this.getName(), param);
        }

        @Override
        public void applyPostCreate(T param) {
        }

        @Override
        public void rollback() {
            AbstractPropertyConfiguration.this.getConfigs().remove(AbstractPropertyConfiguration.this.getName());
        }
    }
}

