/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.logmanager.config.ValueExpression;

class ValueParser {
    private static final int KEY = 0;
    private static final int VALUE = 1;

    ValueParser() {
    }

    static Map<String, String> stringToMap(String s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        char[] chars = s.toCharArray();
        int state = 0;
        block12: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (state) {
                case 0: {
                    switch (c) {
                        case '\\': {
                            char next;
                            if (chars.length > ++i && ((next = chars[i]) == '=' || next == '\\')) {
                                key.append(next);
                                continue block12;
                            }
                            throw new IllegalStateException("Escape character found at invalid position " + i + ". Only characters '=' and '\\' need to be escaped for a key.");
                        }
                        case '=': {
                            state = 1;
                            continue block12;
                        }
                    }
                    key.append(c);
                    continue block12;
                }
                case 1: {
                    switch (c) {
                        case '\\': {
                            char next;
                            if (chars.length > ++i && ((next = chars[i]) == ',' || next == '\\')) {
                                value.append(next);
                                continue block12;
                            }
                            throw new IllegalStateException("Escape character found at invalid position " + i + ". Only characters ',' and '\\' need to be escaped for a value.");
                        }
                        case ',': {
                            if (key.length() > 0) {
                                ValueExpression<String> valueExpression = ValueExpression.STRING_RESOLVER.resolve(value.toString());
                                map.put(key.toString(), valueExpression.getResolvedValue());
                                key.setLength(0);
                            }
                            value.setLength(0);
                            state = 0;
                            continue block12;
                        }
                    }
                    value.append(c);
                    continue block12;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (key.length() > 0) {
            ValueExpression<String> valueExpression = ValueExpression.STRING_RESOLVER.resolve(value.toString());
            map.put(key.toString(), valueExpression.getResolvedValue());
        }
        return Collections.unmodifiableMap(map);
    }
}

