/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.lang.module.ModuleDescriptor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.modules.Module;
import org.jboss.modules.Version;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class JDKSpecific {
    static final StackWalker WALKER = AccessController.doPrivileged(new GetStackWalkerAction());
    private static final boolean JBOSS_MODULES;

    private JDKSpecific() {
    }

    static boolean isModularJvm() {
        return true;
    }

    static Class<?> findCallingClass(Set<ClassLoader> rejectClassLoaders) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return (Class)AccessController.doPrivileged(new FindCallingClassAction(rejectClassLoaders));
        }
        return (Class)WALKER.walk(new FindFirstWalkFunction(rejectClassLoaders));
    }

    static Collection<Class<?>> findCallingClasses(Set<ClassLoader> rejectClassLoaders) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return (Collection)AccessController.doPrivileged(new FindCallingClassesAction(rejectClassLoaders));
        }
        return (Collection)WALKER.walk(new FindAllWalkFunction(rejectClassLoaders));
    }

    static void calculateCaller(ExtLogRecord logRecord) {
        WALKER.walk(new CallerCalcFunction(logRecord));
    }

    static void calculateJdkModule(ExtLogRecord logRecord, Class<?> clazz) {
        java.lang.Module module = clazz.getModule();
        if (module != null) {
            logRecord.setSourceModuleName(module.getName());
            ModuleDescriptor descriptor = module.getDescriptor();
            if (descriptor != null) {
                Optional<ModuleDescriptor.Version> optional = descriptor.version();
                if (optional.isPresent()) {
                    logRecord.setSourceModuleVersion(optional.get().toString());
                } else {
                    logRecord.setSourceModuleVersion(null);
                }
            }
        }
    }

    static void calculateModule(ExtLogRecord logRecord, Class<?> clazz) {
        Module module = Module.forClass(clazz);
        if (module != null) {
            logRecord.setSourceModuleName(module.getName());
            Version version = module.getVersion();
            if (version != null) {
                logRecord.setSourceModuleVersion(version.toString());
            } else {
                logRecord.setSourceModuleVersion(null);
            }
        } else {
            JDKSpecific.calculateJdkModule(logRecord, clazz);
        }
    }

    static {
        boolean jbossModules = false;
        try {
            Module.getStartTime();
            jbossModules = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JBOSS_MODULES = jbossModules;
    }

    static final class FindAllWalkFunction
    implements Function<Stream<StackWalker.StackFrame>, Collection<Class<?>>> {
        private final Set<ClassLoader> rejectClassLoaders;

        FindAllWalkFunction(Set<ClassLoader> rejectClassLoaders) {
            this.rejectClassLoaders = rejectClassLoaders;
        }

        @Override
        public Collection<Class<?>> apply(Stream<StackWalker.StackFrame> stream) {
            LinkedHashSet results = new LinkedHashSet();
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                Class<?> clazz = ((StackWalker.StackFrame)iterator.next()).getDeclaringClass();
                ClassLoader classLoader = clazz.getClassLoader();
                if (classLoader == null || this.rejectClassLoaders.contains(classLoader)) continue;
                results.add(clazz);
            }
            return results;
        }
    }

    static final class FindFirstWalkFunction
    implements Function<Stream<StackWalker.StackFrame>, Class<?>> {
        private final Set<ClassLoader> rejectClassLoaders;

        FindFirstWalkFunction(Set<ClassLoader> rejectClassLoaders) {
            this.rejectClassLoaders = rejectClassLoaders;
        }

        @Override
        public Class<?> apply(Stream<StackWalker.StackFrame> stream) {
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                Class<?> clazz = ((StackWalker.StackFrame)iterator.next()).getDeclaringClass();
                ClassLoader classLoader = clazz.getClassLoader();
                if (this.rejectClassLoaders.contains(classLoader)) continue;
                return clazz;
            }
            return null;
        }
    }

    static final class FindCallingClassesAction
    implements PrivilegedAction<Collection<Class<?>>> {
        private final Set<ClassLoader> rejectClassLoaders;

        FindCallingClassesAction(Set<ClassLoader> rejectClassLoaders) {
            this.rejectClassLoaders = rejectClassLoaders;
        }

        @Override
        public Collection<Class<?>> run() {
            return (Collection)WALKER.walk(new FindAllWalkFunction(this.rejectClassLoaders));
        }
    }

    static final class FindCallingClassAction
    implements PrivilegedAction<Class<?>> {
        private final Set<ClassLoader> rejectClassLoaders;

        FindCallingClassAction(Set<ClassLoader> rejectClassLoaders) {
            this.rejectClassLoaders = rejectClassLoaders;
        }

        @Override
        public Class<?> run() {
            return (Class)WALKER.walk(new FindFirstWalkFunction(this.rejectClassLoaders));
        }
    }

    static final class GetStackWalkerAction
    implements PrivilegedAction<StackWalker> {
        GetStackWalkerAction() {
        }

        @Override
        public StackWalker run() {
            return StackWalker.getInstance(EnumSet.of(StackWalker.Option.RETAIN_CLASS_REFERENCE));
        }
    }

    static final class CallerCalcFunction
    implements Function<Stream<StackWalker.StackFrame>, Void> {
        private final ExtLogRecord logRecord;

        CallerCalcFunction(ExtLogRecord logRecord) {
            this.logRecord = logRecord;
        }

        @Override
        public Void apply(Stream<StackWalker.StackFrame> stream) {
            String loggerClassName = this.logRecord.getLoggerClassName();
            Iterator iterator = stream.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                StackWalker.StackFrame frame = (StackWalker.StackFrame)iterator.next();
                Class<?> clazz = frame.getDeclaringClass();
                if (clazz.getName().equals(loggerClassName)) {
                    found = true;
                    continue;
                }
                if (!found) continue;
                this.logRecord.setSourceClassName(frame.getClassName());
                this.logRecord.setSourceMethodName(frame.getMethodName());
                this.logRecord.setSourceFileName(frame.getFileName());
                this.logRecord.setSourceLineNumber(frame.getLineNumber());
                if (JBOSS_MODULES) {
                    JDKSpecific.calculateModule(this.logRecord, clazz);
                } else {
                    JDKSpecific.calculateJdkModule(this.logRecord, clazz);
                }
                return null;
            }
            this.logRecord.setUnknownCaller();
            return null;
        }
    }
}

