/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.ref.PhantomReference;
import io.smallrye.common.ref.Reaper;
import io.smallrye.common.ref.Reference;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.AtomicArray;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextInitializer;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.StandardOutputStreams;

final class LoggerNode
implements AutoCloseable {
    private static final Reaper<Logger, LoggerNode> REAPER = new Reaper<Logger, LoggerNode>(){

        public void reap(Reference<Logger, LoggerNode> reference) {
            ((LoggerNode)reference.getAttachment()).activeLoggers.remove(reference);
        }
    };
    private static final StackTraceElement[] EMPTY_STACK = new StackTraceElement[0];
    private final LogContext context;
    private final LoggerNode parent;
    private final String fullName;
    private final ConcurrentMap<String, LoggerNode> children;
    private volatile Handler[] handlers;
    private volatile boolean useParentHandlers = true;
    private volatile Filter filter;
    private volatile boolean useParentFilter = false;
    private final Set<Reference<Logger, LoggerNode>> activeLoggers = ConcurrentHashMap.newKeySet();
    private volatile Map<Logger.AttachmentKey<?>, Object> attachments;
    private static final VarHandle attachmentHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "attachments", VarHandle.class, LoggerNode.class, Map.class);
    private static final AtomicArray<LoggerNode, Handler> handlersUpdater = AtomicArray.create(AtomicReferenceFieldUpdater.newUpdater(LoggerNode.class, Handler[].class, "handlers"), Handler.class);
    private volatile Level level;
    private volatile int effectiveLevel;
    private final int effectiveMinLevel;

    LoggerNode(LogContext context) {
        this.parent = null;
        this.fullName = "";
        this.context = context;
        LogContextInitializer initializer = context.getInitializer();
        Level minLevel = initializer.getMinimumLevel(this.fullName);
        this.effectiveMinLevel = Objects.requireNonNullElse(minLevel, Level.ALL).intValue();
        Level initialLevel = initializer.getInitialLevel(this.fullName);
        if (initialLevel != null) {
            this.level = initialLevel;
            this.effectiveLevel = initialLevel.intValue();
        } else {
            this.effectiveLevel = Logger.INFO_INT;
        }
        this.handlers = LoggerNode.safeCloneHandlers(initializer.getInitialHandlers(this.fullName));
        this.children = context.createChildMap();
        this.attachments = Map.of();
    }

    private LoggerNode(LogContext context, LoggerNode parent, String nodeName) {
        nodeName = nodeName.trim();
        if (nodeName.length() == 0 && parent == null) {
            throw new IllegalArgumentException("nodeName is empty, or just whitespace and has no parent");
        }
        this.parent = parent;
        this.fullName = parent.parent == null ? (nodeName.isEmpty() ? "." : nodeName) : parent.fullName + "." + nodeName;
        this.context = context;
        LogContextInitializer initializer = context.getInitializer();
        Level minLevel = initializer.getMinimumLevel(this.fullName);
        this.effectiveMinLevel = minLevel != null ? minLevel.intValue() : parent.effectiveMinLevel;
        Level initialLevel = initializer.getInitialLevel(this.fullName);
        if (initialLevel != null) {
            this.level = initialLevel;
            this.effectiveLevel = initialLevel.intValue();
        } else {
            this.effectiveLevel = parent.effectiveLevel;
        }
        this.handlers = LoggerNode.safeCloneHandlers(initializer.getInitialHandlers(this.fullName));
        this.children = context.createChildMap();
        this.attachments = Map.of();
    }

    static Handler[] safeCloneHandlers(Handler ... initialHandlers) {
        if (initialHandlers == null || initialHandlers.length == 0) {
            return LogContextInitializer.NO_HANDLERS;
        }
        Handler[] clone = (Handler[])initialHandlers.clone();
        int length = clone.length;
        for (int i = 0; i < length; ++i) {
            if (clone[i] != null) continue;
            int cnt = 1;
            ++i;
            while (i < length) {
                if (clone[i] == null) {
                    ++cnt;
                }
                ++i;
            }
            int newLen = length - cnt;
            if (newLen == 0) {
                return LogContextInitializer.NO_HANDLERS;
            }
            Handler[] newClone = new Handler[newLen];
            int k = 0;
            for (int j = 0; j < length; ++j) {
                if (clone[j] == null) continue;
                newClone[k++] = clone[j];
            }
            return newClone;
        }
        return clone;
    }

    @Override
    public void close() {
        ReentrantLock treeLock = this.context.treeLock;
        treeLock.lock();
        try {
            this.filter = null;
            if ("".equals(this.fullName)) {
                this.level = Level.INFO;
                this.effectiveLevel = Level.INFO.intValue();
            } else {
                this.level = null;
                this.effectiveLevel = this.parent.effectiveLevel;
            }
            handlersUpdater.clear(this);
            this.useParentFilter = false;
            this.useParentHandlers = true;
            attachmentHandle.setVolatile(this, Map.of());
            this.children.clear();
        }
        finally {
            treeLock.unlock();
        }
    }

    LoggerNode getOrCreate(String name) {
        LoggerNode appearingNode;
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null && (appearingNode = this.children.putIfAbsent(nextName, nextNode = new LoggerNode(this.context, this, nextName))) != null) {
            nextNode = appearingNode;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getOrCreate(name.substring(i + 1));
    }

    LoggerNode getIfExists(String name) {
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null) {
            return null;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getIfExists(name.substring(i + 1));
    }

    Logger createLogger() {
        Logger logger = new Logger(this, this.fullName);
        this.activeLoggers.add((Reference<Logger, LoggerNode>)new PhantomReference((Object)logger, (Object)this, REAPER));
        return logger;
    }

    Collection<LoggerNode> getChildren() {
        return this.children.values();
    }

    LogContext getContext() {
        return this.context;
    }

    void setEffectiveLevel(int newLevel) {
        if (this.level == null) {
            this.effectiveLevel = newLevel;
            for (LoggerNode node : this.children.values()) {
                if (node == null) continue;
                node.setEffectiveLevel(newLevel);
            }
        }
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    Filter getFilter() {
        return this.filter;
    }

    boolean getUseParentFilters() {
        return this.useParentFilter;
    }

    void setUseParentFilters(boolean useParentFilter) {
        this.useParentFilter = useParentFilter;
    }

    int getEffectiveLevel() {
        return this.effectiveLevel;
    }

    boolean isLoggableLevel(int level) {
        return level != Logger.OFF_INT && level >= this.effectiveMinLevel && level >= this.effectiveLevel;
    }

    Handler[] getHandlers() {
        return this.handlers;
    }

    Handler[] clearHandlers() {
        Handler[] handlers = this.handlers;
        handlersUpdater.clear(this);
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    void removeHandler(Handler handler) {
        handlersUpdater.remove(this, handler, true);
    }

    void addHandler(Handler handler) {
        handlersUpdater.add(this, handler);
    }

    Handler[] setHandlers(Handler[] handlers) {
        return handlersUpdater.getAndSet(this, (Handler[])handlers);
    }

    boolean compareAndSetHandlers(Handler[] oldHandlers, Handler[] newHandlers) {
        return handlersUpdater.compareAndSet(this, (Handler[])oldHandlers, (Handler[])newHandlers);
    }

    boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    void setUseParentHandlers(boolean useParentHandlers) {
        this.useParentHandlers = useParentHandlers;
    }

    void publish(ExtLogRecord record) {
        LoggerNode parent;
        for (final Handler handler : this.handlers) {
            try {
                handler.publish(record);
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (Throwable t) {
                Exception e;
                ErrorManager errorManager = AccessController.doPrivileged(new PrivilegedAction<ErrorManager>(){

                    @Override
                    public ErrorManager run() {
                        return handler.getErrorManager();
                    }
                });
                if (errorManager == null) continue;
                if (t instanceof Exception) {
                    e = (Exception)t;
                } else {
                    e = new UndeclaredThrowableException(t);
                    e.setStackTrace(EMPTY_STACK);
                }
                try {
                    errorManager.error("Handler publication threw an exception", e, 1);
                }
                catch (Throwable t2) {
                    StandardOutputStreams.printError(t2, "Handler.reportError caught an exception");
                }
            }
        }
        if (this.useParentHandlers && (parent = this.parent) != null) {
            parent.publish(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLevel(Level newLevel) {
        ReentrantLock treeLock = this.context.treeLock;
        treeLock.lock();
        try {
            int newEffectiveLevel;
            int oldEffectiveLevel = this.effectiveLevel;
            if (newLevel != null) {
                this.level = newLevel;
                newEffectiveLevel = newLevel.intValue();
            } else {
                LoggerNode parent = this.parent;
                if (parent == null) {
                    this.level = Level.INFO;
                    newEffectiveLevel = Logger.INFO_INT;
                } else {
                    this.level = null;
                    newEffectiveLevel = parent.effectiveLevel;
                }
            }
            this.effectiveLevel = newEffectiveLevel;
            if (oldEffectiveLevel != newEffectiveLevel) {
                for (LoggerNode node : this.children.values()) {
                    if (node == null) continue;
                    node.setEffectiveLevel(newEffectiveLevel);
                }
            }
        }
        finally {
            treeLock.unlock();
        }
    }

    Level getLevel() {
        return this.level;
    }

    <V> V getAttachment(Logger.AttachmentKey<V> key) {
        Assert.checkNotNullParam((String)"key", key);
        return (V)this.attachments.get(key);
    }

    <V> V attach(Logger.AttachmentKey<V> key, V value) {
        V old;
        HashMap newAttachments;
        Map<Logger.AttachmentKey<?>, Object> oldAttachments;
        Assert.checkNotNullParam((String)"key", key);
        Assert.checkNotNullParam((String)"value", value);
        do {
            oldAttachments = this.attachments;
            newAttachments = new HashMap(oldAttachments);
            old = newAttachments.put(key, value);
        } while (!attachmentHandle.compareAndSet(this, oldAttachments, Map.copyOf(newAttachments)));
        return old;
    }

    <V> V attachIfAbsent(Logger.AttachmentKey<V> key, V value) {
        HashMap newAttachments;
        Map<Logger.AttachmentKey<?>, Object> oldAttachments;
        Assert.checkNotNullParam((String)"key", key);
        Assert.checkNotNullParam((String)"value", value);
        do {
            if ((oldAttachments = this.attachments).containsKey(key)) {
                return (V)oldAttachments.get(key);
            }
            newAttachments = new HashMap(oldAttachments);
            newAttachments.put(key, value);
        } while (!attachmentHandle.compareAndSet(this, oldAttachments, Map.copyOf(newAttachments)));
        return null;
    }

    public <V> V detach(Logger.AttachmentKey<V> key) {
        Object result;
        Map newAttachments;
        Map<Logger.AttachmentKey<?>, Object> oldAttachments;
        Assert.checkNotNullParam((String)"key", key);
        do {
            if ((result = (oldAttachments = this.attachments).get(key)) == null) {
                return null;
            }
            int size = oldAttachments.size();
            if (size == 1) {
                newAttachments = Map.of();
                continue;
            }
            newAttachments = new HashMap(oldAttachments);
            newAttachments.remove(key);
        } while (!attachmentHandle.compareAndSet(this, oldAttachments, Map.copyOf(newAttachments)));
        return (V)result;
    }

    String getFullName() {
        return this.fullName;
    }

    LoggerNode getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLoggable(ExtLogRecord record) {
        if (!this.useParentFilter) {
            Filter filter = this.filter;
            return filter == null || filter.isLoggable(record);
        }
        ReentrantLock treeLock = this.context.treeLock;
        treeLock.lock();
        try {
            boolean bl = LoggerNode.isLoggable(this, record);
            return bl;
        }
        finally {
            treeLock.unlock();
        }
    }

    private static boolean isLoggable(LoggerNode loggerNode, ExtLogRecord record) {
        if (loggerNode == null) {
            return true;
        }
        Filter filter = loggerNode.filter;
        return !(filter != null && !filter.isLoggable(record) || loggerNode.useParentFilter && !LoggerNode.isLoggable(loggerNode.getParent(), record));
    }

    Enumeration<String> getLoggerNames() {
        return new Enumeration<String>(){
            final Iterator<LoggerNode> children;
            String next;
            Enumeration<String> sub;
            {
                this.children = LoggerNode.this.getChildren().iterator();
                this.next = LoggerNode.this.activeLoggers.isEmpty() ? null : LoggerNode.this.fullName;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.next == null) {
                    while (this.sub == null) {
                        if (this.children.hasNext()) {
                            LoggerNode child = this.children.next();
                            this.sub = child.getLoggerNames();
                            continue;
                        }
                        return false;
                    }
                    if (this.sub.hasMoreElements()) {
                        this.next = this.sub.nextElement();
                        return true;
                    }
                    this.sub = null;
                }
                return true;
            }

            @Override
            public String nextElement() {
                try {
                    String string = this.next;
                    return string;
                }
                finally {
                    this.next = null;
                }
            }
        };
    }
}

