/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j;

import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.log4j.JBossLoggerContext;
import org.jboss.logmanager.log4j.JBossStatusListener;

public class JBossLoggerContextFactory
implements LoggerContextFactory {
    private static final Logger.AttachmentKey<Map<Object, LoggerContext>> CONTEXT_KEY = new Logger.AttachmentKey();

    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext) {
        return this.getLoggerContext(loader, externalContext, currentContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerContext getContext(String fqcn, ClassLoader loader, Object externalContext, boolean currentContext, URI configLocation, String name) {
        try {
            LoggerContext loggerContext = this.getLoggerContext(loader, externalContext, currentContext);
            return loggerContext;
        }
        finally {
            if (configLocation != null) {
                StatusLogger.getLogger().warn("Configuration is not allowed for the JBoss Log Manager binding. Ignoring configuration file {}.", (Object)configLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(LoggerContext context) {
        LogContext logContext = LogContext.getLogContext();
        Map contexts = (Map)logContext.getAttachment("", CONTEXT_KEY);
        if (contexts != null) {
            Map map = contexts;
            synchronized (map) {
                Iterator iter = contexts.values().iterator();
                while (iter.hasNext()) {
                    LoggerContext c = (LoggerContext)iter.next();
                    if (!c.equals(context)) continue;
                    iter.remove();
                    break;
                }
                if (contexts.isEmpty()) {
                    Logger rootLogger = logContext.getLogger("");
                    rootLogger.detach(CONTEXT_KEY);
                    JBossStatusListener.remove(logContext);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerContext getLoggerContext(ClassLoader classLoader, Object externalContext, boolean currentContext) {
        if (currentContext || classLoader == null) {
            return this.getOrCreateLoggerContext(LogContext.getLogContext(), externalContext);
        }
        ClassLoader current = JBossLoggerContextFactory.getTccl();
        try {
            JBossLoggerContextFactory.setTccl(classLoader);
            LoggerContext loggerContext = this.getOrCreateLoggerContext(LogContext.getLogContext(), externalContext);
            return loggerContext;
        }
        finally {
            JBossLoggerContextFactory.setTccl(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerContext getOrCreateLoggerContext(final LogContext logContext, final Object externalContext) {
        Map appearing;
        Logger rootLogger = logContext.getLogger("");
        Map<Object, Object> contexts = (HashMap<Object, LoggerContext>)rootLogger.getAttachment(CONTEXT_KEY);
        if (contexts == null && (appearing = (Map)rootLogger.attachIfAbsent(CONTEXT_KEY, contexts = new HashMap<Object, LoggerContext>())) != null) {
            contexts = appearing;
        }
        HashMap<Object, LoggerContext> hashMap = contexts;
        synchronized (hashMap) {
            JBossStatusListener.registerIfAbsent(logContext);
            return contexts.computeIfAbsent(externalContext, new Function<Object, LoggerContext>(){

                @Override
                public LoggerContext apply(Object o) {
                    return new JBossLoggerContext(logContext, externalContext);
                }
            });
        }
    }

    private static ClassLoader getTccl() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static void setTccl(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }
}

