/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.scope;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeLevel
implements Serializable,
Comparable<ScopeLevel> {
    private static final long serialVersionUID = 9090783215048463821L;
    private static final ConcurrentHashMap<String, Integer> levelsByName = new ConcurrentHashMap();
    private final int level;
    private final String name;

    public static int getScopeLevel(String name) {
        Integer result = levelsByName.get(name);
        if (result != null) {
            return result;
        }
        return 0;
    }

    public ScopeLevel(int level, String name) {
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.level = level;
        this.name = name;
        levelsByName.put(name, level);
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(ScopeLevel o) {
        return this.level - o.level;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof ScopeLevel)) {
            return false;
        }
        ScopeLevel other = (ScopeLevel)object;
        return this.level == other.level;
    }

    public int hashCode() {
        return this.level;
    }
}

