/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.MutableManagedComponent;
import org.jboss.managed.api.RunState;
import org.jboss.managed.api.RunStateMapper;
import org.jboss.managed.api.annotation.RunStateProperty;
import org.jboss.managed.plugins.DelegateManagedCommonImpl;
import org.jboss.metatype.api.values.MetaValue;

public class ManagedComponentImpl
extends DelegateManagedCommonImpl
implements MutableManagedComponent,
Serializable {
    private static final long serialVersionUID = 1L;
    private ManagedDeployment owner;
    private ComponentType type;
    private RunState runState = RunState.UNKNOWN;
    private transient RunStateMapper stateMapper;
    private transient ManagedProperty stateProperty;

    public ManagedComponentImpl(ComponentType type, ManagedDeployment owner, ManagedObject mo) {
        this(type, owner, mo, null);
    }

    public ManagedComponentImpl(ComponentType type, ManagedDeployment owner, ManagedObject mo, RunStateMapper stateMapper) {
        super(mo);
        this.type = type;
        this.owner = owner;
        this.stateMapper = stateMapper;
        Map<String, ManagedProperty> props = mo.getProperties();
        if (props != null) {
            for (ManagedProperty prop : props.values()) {
                if (!prop.hasAnnotation(RunStateProperty.class.getName())) continue;
                this.stateProperty = prop;
                if (stateMapper == null) {
                    RunStateProperty rsp = (RunStateProperty)prop.getAnnotations().get(RunStateProperty.class.getName());
                    String[] metaValues = rsp.metaValues();
                    String[] enumValues = rsp.enumValues();
                    try {
                        Constructor<? extends RunStateMapper> ctor = rsp.value().getConstructor(metaValues.getClass(), enumValues.getClass());
                        this.stateMapper = ctor.newInstance(metaValues, enumValues);
                    }
                    catch (Exception e) {
                        try {
                            this.stateMapper = rsp.value().newInstance();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                }
                this.runState = this.updateRunState();
                break;
            }
        }
    }

    public RunStateMapper getStateMapper() {
        return this.stateMapper;
    }

    public void setStateMapper(RunStateMapper stateMapper) {
        this.stateMapper = stateMapper;
    }

    public RunState getRunState() {
        return this.runState;
    }

    public void setRunState(RunState runState) {
        this.runState = runState;
    }

    public RunState updateRunState() {
        RunState state = RunState.UNKNOWN;
        if (this.stateMapper != null && this.stateProperty != null) {
            MetaValue value = this.stateProperty.getValue();
            this.runState = state = this.stateMapper.getRunState(this.stateProperty, value);
        }
        return this.runState;
    }

    public ManagedDeployment getDeployment() {
        return this.owner;
    }

    public ComponentType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder(super.toString());
        tmp.append('{');
        tmp.append("name=");
        tmp.append(super.getName());
        tmp.append(", type=");
        tmp.append(this.type);
        tmp.append(", owner=ManagedDeployment@");
        tmp.append(System.identityHashCode(this.owner));
        tmp.append('}');
        return tmp.toString();
    }
}

