/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support.beans;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
@ManagementObject(properties = ManagementProperties.EXPLICIT)
@XmlRootElement(name="bean")
@XmlType(name="beanType", propOrder={"aliasMetaData", "related", "annotations", "classLoader", "constructor", "properties", "create", "start", "stop", "destroy", "depends", "demands", "supplies", "installs", "uninstalls", "installCallbacks", "uninstallCallbacks"})
public class ABeanMetaData extends AFeatureMetaData
   implements IBeanMetaData, IBeanMetaDataFactory
{
   private static final long serialVersionUID = 1;
   private String bean;
   private String name;
   /** The properties configuration Set<IPropertyMetaData> */
   private Set<IPropertyMetaData> properties;

   public String getBean()
   {
      return bean;
   }
   public void setBean(String bean)
   {
      this.bean = bean;
   }
   public String getName()
   {
      return name;
   }
   public void setName(String name)
   {
      this.name = name;
   }

   /**
    * Get a property
    *
    * @param name the name
    * @return the property name
    */
   public IPropertyMetaData getProperty(String name)
   {
      if (name == null)
         throw new IllegalArgumentException("Null name");
      if (properties != null && properties.size() > 0)
      {
         for (IPropertyMetaData prop : properties)
         {
            if (name.equals(prop.getName()))
               return prop;
         }
      }
      return null;
   }

   /**
    * Add a property
    *
    * @param property the property
    */
   public void addProperty(IPropertyMetaData property)
   {
      if (property == null)
         throw new IllegalArgumentException("Null property");
      if (properties == null)
         properties = new HashSet<IPropertyMetaData>();
      properties.add(property);
   }

   public Set<IPropertyMetaData> getProperties()
   {
      return properties;
   }

   /**
    * Set the propertiess.
    *
    * @param properties Set<PropertyMetaData>
    */
   @ManagementProperty(managed=true)
   @XmlElement(name="property", type=APropertyMetaData.class)
   public void setProperties(Set<IPropertyMetaData> properties)
   {
      this.properties = properties;
   }
   public List<IBeanMetaData> getBeans()
   {
      ArrayList<IBeanMetaData> beans = new ArrayList<IBeanMetaData>();
      beans.add(this);
      return beans;
   }

   public String toString()
   {
      return "ABeanMetaData("+bean+";"+name+")";
   }
}
