/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support;

import org.jboss.managed.api.annotation.ConstraintsPopulatorFactory;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.plugins.constraints.NumberConstraintsPopulatorFactory;
import org.jboss.managed.plugins.constraints.StringLegalValuesPopulatorFactory;

/**
 * Test bean for validating ConstraintsPopulatorFactory on managed properties
 * @author Scott.Stark@jboss.org
 * @version $Revision: 81573 $
 */
@ManagementObject
public class ConstrainedBean
{
   private float temperature;
   private Float pi;
   private Short dayOfYear;
   private int day;
   private String month;

   @ManagementProperty()
   @ConstraintsPopulatorFactory(value=NumberConstraintsPopulatorFactory.class,
         min="0",max="100")
   public float getTemperature()
   {
      return temperature;
   }
   public void setTemperature(float temperature)
   {
      this.temperature = temperature;
   }
   @ManagementProperty()
   @ConstraintsPopulatorFactory(value=NumberConstraintsPopulatorFactory.class,
         min="3",max="3.14159")
   public Float getPi()
   {
      return pi;
   }
   public void setPi(Float pi)
   {
      this.pi = pi;
   }
   @ManagementProperty()
   @ConstraintsPopulatorFactory(value=NumberConstraintsPopulatorFactory.class,
         min="1",max="365")
   public Short getDayOfYear()
   {
      return dayOfYear;
   }
   public void setDayOfYear(Short dayOfYear)
   {
      this.dayOfYear = dayOfYear;
   }
   @ManagementProperty()
   @ConstraintsPopulatorFactory(value=StringLegalValuesPopulatorFactory.class,
         legalValues={"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"})
   public String getMonth()
   {
      return month;
   }
   public void setMonth(String month)
   {
      this.month = month;
   }
   @ManagementProperty()
   @ConstraintsPopulatorFactory(value=NumberConstraintsPopulatorFactory.class,
         min="1",max="31")
   public int getDay()
   {
      return day;
   }
   public void setDay(int day)
   {
      this.day = day;
   }
}
