/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.api.factory;

import org.jboss.managed.spi.factory.ManagedObjectBuilder;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/**
 * Base managed object definition.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public abstract class BaseManagedObjectDefinition extends JBossObject
{
   private Class<?> type;
   private ManagedObjectBuilder builder;

   protected BaseManagedObjectDefinition()
   {
   }

   protected BaseManagedObjectDefinition(Class<?> type, ManagedObjectBuilder builder)
   {
      this.type = type;
      this.builder = builder;
   }

   /**
    * Is definition valid.
    *
    * @return true if valid
    */
   public boolean isValid()
   {
      return type != null && builder != null;
   }

   /**
    * Get type.
    *
    * @return the type
    */
   public Class<?> getType()
   {
      return type;
   }

   /**
    * Set type.
    *
    * @param type the type
    */
   public void setType(Class<?> type)
   {
      this.type = type;
   }

   /**
    * Get builder.
    *
    * @return the builder
    */
   public ManagedObjectBuilder getBuilder()
   {
      return builder;
   }

   /**
    * Set builder.
    *
    * @param builder the builder
    */
   public void setBuilder(ManagedObjectBuilder builder)
   {
      this.builder = builder;
   }

   @Override
   public void toShortString(JBossStringBuilder buffer)
   {
      buffer.append("type=").append(type);
      buffer.append(", builder=").append(builder);
   }

   @Override
   protected void toString(JBossStringBuilder buffer)
   {
      buffer.append("type=").append(type);
      buffer.append(", builder=").append(builder);
   }
}