/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins.factory;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.config.spi.Configuration;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementRuntimeRef;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.managed.spi.factory.ManagedObjectPopulator;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractManagedObjectPopulator<T>
implements ManagedObjectPopulator<T> {
    private static Logger log = Logger.getLogger(AbstractManagedObjectPopulator.class);
    private Configuration configuration;
    private InstanceClassFactory<?> defaultInstanceFactory;
    private Map<Class<?>, InstanceClassFactory<?>> instanceFactories;

    public AbstractManagedObjectPopulator(Configuration configuration) {
        this(configuration, null, null);
    }

    public AbstractManagedObjectPopulator(Configuration configuration, InstanceClassFactory<?> defaultInstanceFactory, Map<Class<?>, InstanceClassFactory<?>> instanceFactories) {
        this.configuration = configuration;
        this.defaultInstanceFactory = defaultInstanceFactory;
        this.instanceFactories = instanceFactories;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public InstanceClassFactory<?> getDefaultInstanceFactory() {
        return this.defaultInstanceFactory;
    }

    public void setDefaultInstanceFactory(InstanceClassFactory<?> defaultInstanceFactory) {
        this.defaultInstanceFactory = defaultInstanceFactory;
    }

    public Map<Class<?>, InstanceClassFactory<?>> getInstanceFactories() {
        return this.instanceFactories;
    }

    public void setInstanceFactories(Map<Class<?>, InstanceClassFactory<?>> instanceFactories) {
        this.instanceFactories = instanceFactories;
    }

    @Override
    public void createObject(ManagedObject managedObject, Class<T> clazz) {
        if (managedObject == null) {
            throw new IllegalArgumentException("Null managed object");
        }
        if (!(managedObject instanceof MutableManagedObject)) {
            throw new IllegalStateException("Unable to create object " + managedObject.getClass().getName());
        }
        MutableManagedObject managedObjectImpl = (MutableManagedObject)managedObject;
        T object = this.createUnderlyingObject(managedObjectImpl, clazz);
        this.populateManagedObject(managedObjectImpl, object);
    }

    @Override
    public void populateManagedObject(MutableManagedObject managedObject, T object) {
        managedObject.setAttachment(object);
        this.populateValues(managedObject, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> InstanceClassFactory<X> getInstanceClassFactory(Class<X> clazz) {
        Map<Class<?>, InstanceClassFactory<?>> map = this.instanceFactories;
        synchronized (map) {
            InstanceClassFactory<?> factory = this.instanceFactories.get(clazz);
            if (factory != null) {
                return factory;
            }
        }
        InstanceClassFactory<?> factory = this.defaultInstanceFactory;
        return factory;
    }

    protected T createUnderlyingObject(MutableManagedObject managedObject, Class<T> clazz) {
        BeanInfo beanInfo = this.configuration.getBeanInfo(clazz);
        try {
            Object result = beanInfo.newInstance();
            return clazz.cast(result);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to create new object for " + managedObject + " clazz=" + clazz, t);
        }
    }

    protected void populateValues(MutableManagedObject managedObject, T object) {
        Class<?> moClass;
        InstanceClassFactory<?> icf = this.getInstanceClassFactory(object.getClass());
        try {
            moClass = icf.getManagedObjectClass(object);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        BeanInfo beanInfo = this.configuration.getBeanInfo(moClass);
        Object componentName = null;
        Map<String, ManagedProperty> properties = managedObject.getProperties();
        if (properties != null && properties.size() > 0) {
            for (ManagedProperty property : properties.values()) {
                ManagementRuntimeRef runtimeRef;
                Map<String, Annotation> annotations;
                MetaValue value;
                block10: {
                    value = null;
                    try {
                        value = icf.getValue(beanInfo, property, object);
                    }
                    catch (Throwable t) {
                        if (!log.isTraceEnabled()) break block10;
                        log.trace((Object)("Failed to access value for property: " + property), t);
                    }
                }
                if (value != null) {
                    property.setField("value", (Serializable)value);
                }
                if ((annotations = property.getAnnotations()) == null) continue;
                ManagementObjectID id = (ManagementObjectID)annotations.get(ManagementObjectID.class.getName());
                if (id != null) {
                    if (value == null || !value.getMetaType().isSimple()) {
                        log.warn((Object)("Cannot create String name from non-Simple property: " + property + ", value=" + value));
                        continue;
                    }
                    SimpleValue svalue = (SimpleValue)value;
                    String name = "" + svalue.getValue();
                    managedObject.setName(name);
                }
                if ((runtimeRef = (ManagementRuntimeRef)annotations.get(ManagementRuntimeRef.class.getName())) == null || (componentName = icf.getComponentName(beanInfo, property, object, value)) != null || this.defaultInstanceFactory == null) continue;
                InstanceClassFactory<?> dicf = this.defaultInstanceFactory;
                componentName = dicf.getComponentName(beanInfo, property, object, value);
            }
        }
        if (componentName == null) {
            componentName = icf.getComponentName(null, null, object, null);
        }
        managedObject.setComponentName(componentName);
    }
}

