/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins.factory;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.config.spi.Configuration;
import org.jboss.logging.Logger;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.plugins.BasicDeploymentTemplateInfo;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.WritethroughManagedPropertyImpl;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.managed.plugins.factory.PropertyConfigurationAccess;
import org.jboss.managed.spi.factory.ManagedPropertyConstraintsPopulator;
import org.jboss.managed.spi.factory.ManagedPropertyConstraintsPopulatorFactory;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.MetaTypeFactory;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentTemplateInfoFactory {
    private static final Logger log = Logger.getLogger(DeploymentTemplateInfoFactory.class);
    private static final Configuration configuration = PropertyConfigurationAccess.getConfiguration();
    private MetaTypeFactory metaTypeFactory = MetaTypeFactory.getInstance();
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();

    public MetaTypeFactory getMetaTypeFactory() {
        return this.metaTypeFactory;
    }

    public void setMetaTypeFactory(MetaTypeFactory metaTypeFactory) {
        this.metaTypeFactory = metaTypeFactory;
    }

    public MetaValueFactory getMetaValueFactory() {
        return this.metaValueFactory;
    }

    public void setMetaValueFactory(MetaValueFactory metaValueFactory) {
        this.metaValueFactory = metaValueFactory;
    }

    public DeploymentTemplateInfo createTemplateInfo(ManagedObject mo, String name, String description) {
        HashMap<String, ManagedProperty> infoProps = new HashMap<String, ManagedProperty>();
        Map<String, ManagedProperty> props = mo.getProperties();
        if (props != null) {
            for (ManagedProperty prop : props.values()) {
                ManagementProperty mp;
                Map<String, Annotation> pannotations = prop.getAnnotations();
                if (pannotations == null || (mp = (ManagementProperty)pannotations.get(ManagementProperty.class.getName())) == null || !mp.includeInTemplate()) continue;
                infoProps.put(prop.getName(), prop);
            }
        }
        BasicDeploymentTemplateInfo info = new BasicDeploymentTemplateInfo(name, description, infoProps);
        return info;
    }

    public DeploymentTemplateInfo createTemplateInfo(Class<?> attachmentClass, String name, String description) throws Exception {
        return this.createTemplateInfo(BasicDeploymentTemplateInfo.class, attachmentClass, name, description);
    }

    public DeploymentTemplateInfo createTemplateInfo(Class<? extends DeploymentTemplateInfo> infoClass, Class<?> attachmentClass, String name, String description) throws Exception {
        BeanInfo beanInfo = configuration.getBeanInfo(attachmentClass);
        HashMap<String, ManagedProperty> infoProps = new HashMap<String, ManagedProperty>();
        Set propertyInfos = beanInfo.getProperties();
        if (propertyInfos != null && !propertyInfos.isEmpty()) {
            for (PropertyInfo propertyInfo : propertyInfos) {
                ManagementProperty managementProperty = (ManagementProperty)propertyInfo.getUnderlyingAnnotation(ManagementProperty.class);
                if (managementProperty == null || !managementProperty.includeInTemplate()) continue;
                ManagedProperty mp = this.createProperty(propertyInfo, managementProperty);
                infoProps.put(mp.getName(), mp);
            }
        }
        Class[] parameterTypes = new Class[]{String.class, String.class, Map.class};
        Constructor<? extends DeploymentTemplateInfo> ctor = infoClass.getConstructor(parameterTypes);
        DeploymentTemplateInfo info = ctor.newInstance(name, description, infoProps);
        return info;
    }

    protected ManagedProperty createProperty(PropertyInfo propertyInfo, ManagementProperty managementProperty) {
        boolean includeProperty;
        boolean trace = log.isTraceEnabled();
        ManagedProperty property = null;
        boolean bl = includeProperty = !managementProperty.ignored();
        if (includeProperty) {
            Class<? extends ManagedProperty> factory;
            TypeInfo typeInfo;
            Class<? extends Fields> factory2;
            HashMap<String, ManagementProperty> propAnnotations = new HashMap<String, ManagementProperty>();
            propAnnotations.put(ManagementProperty.class.getName(), managementProperty);
            Fields fields = null;
            if (managementProperty != null && (factory2 = managementProperty.fieldsFactory()) != ManagementProperty.NULL_FIELDS_FACTORY.class) {
                try {
                    fields = factory2.newInstance();
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to created Fields", (Throwable)e);
                }
            }
            if (fields == null) {
                fields = new DefaultFieldsImpl();
            }
            if (propertyInfo instanceof Serializable) {
                Serializable info = (Serializable)Serializable.class.cast(propertyInfo);
                fields.setField("propertyInfo", info);
            }
            String propertyName = propertyInfo.getName();
            if (managementProperty != null) {
                propertyName = managementProperty.name();
            }
            if (propertyName.length() == 0) {
                propertyName = propertyInfo.getName();
            }
            fields.setField("name", propertyName);
            String mappedName = propertyInfo.getName();
            if (managementProperty != null) {
                mappedName = managementProperty.mappedName();
            }
            if (mappedName.length() == 0) {
                mappedName = propertyInfo.getName();
            }
            fields.setField("mappedName", mappedName);
            String description = "%Generated%";
            if (managementProperty != null) {
                description = managementProperty.description();
            }
            if (description.equals("%Generated%")) {
                description = propertyName;
            }
            fields.setField("description", description);
            if (trace) {
                log.trace((Object)("Building MangedProperty(name=" + propertyName + ",mappedName=" + mappedName + ") ,annotations=" + propAnnotations));
            }
            boolean mandatory = false;
            if (managementProperty != null) {
                mandatory = managementProperty.mandatory();
            }
            if (mandatory) {
                fields.setField("mandatory", Boolean.TRUE);
            }
            boolean managed = false;
            if (managementProperty != null) {
                managed = managementProperty.managed();
            }
            Object metaType = managed ? ((typeInfo = propertyInfo.getType()).isArray() ? new ArrayMetaType(1, (MetaType)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) : (typeInfo.isCollection() ? new CollectionMetaType(typeInfo.getName(), (MetaType)AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) : AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE)) : this.metaTypeFactory.resolve(propertyInfo.getType());
            fields.setField("metaType", metaType);
            if (!propAnnotations.isEmpty()) {
                fields.setField("annotations", propAnnotations);
            }
            try {
                Class<? extends ManagedPropertyConstraintsPopulatorFactory> factoryClass = managementProperty.constraintsFactory();
                ManagedPropertyConstraintsPopulatorFactory factory3 = factoryClass.newInstance();
                ManagedPropertyConstraintsPopulator populator = factory3.newInstance();
                if (populator != null) {
                    Class clazz = propertyInfo.getBeanInfo().getClassInfo().getType();
                    populator.populateManagedProperty(clazz, propertyInfo, fields);
                }
            }
            catch (Exception e) {
                log.debug((Object)("Failed to populate constraints for: " + propertyInfo), (Throwable)e);
            }
            if (managementProperty != null && (factory = managementProperty.propertyFactory()) != ManagementProperty.NULL_PROPERTY_FACTORY.class) {
                property = AbstractManagedObjectFactory.createManagedProperty(factory, fields);
            }
            if (property == null) {
                property = new WritethroughManagedPropertyImpl(fields, this.metaValueFactory, null);
            }
        }
        return property;
    }
}

